/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.testing;

import io.helidon.config.spi.ConfigNode;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public final class ValueNodeMatcher
extends TypeSafeMatcher<ConfigNode> {
    private final String expectedValue;

    private ValueNodeMatcher(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public static ValueNodeMatcher valueNode(String expectedValue) {
        return new ValueNodeMatcher(expectedValue);
    }

    public void describeTo(Description description) {
        description.appendText("ValueNode with value ").appendValue((Object)this.expectedValue);
    }

    public boolean matchesSafely(ConfigNode actualValue) {
        if (actualValue instanceof ConfigNode.ValueNode) {
            ConfigNode.ValueNode valueNode = (ConfigNode.ValueNode)actualValue;
            return this.expectedValue.equals(valueNode.get());
        }
        return false;
    }

    public void describeMismatchSafely(ConfigNode item, Description description) {
        if (item instanceof ConfigNode.ValueNode) {
            ConfigNode.ValueNode valueNode = (ConfigNode.ValueNode)item;
            description.appendText("got ").appendValue((Object)valueNode.get());
        } else {
            description.appendText("got ").appendValue((Object)item.getClass().getName()).appendText(" ").appendValue((Object)item);
        }
    }
}

