/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.testing;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class CaseSensitivityTester {
    private static final String VLOWER = "lower";
    private static final String VMIXED = "Mixed";
    private static final String VUPPER = "UPPER";
    private static final String VLIST = "LiSt";
    private static final List<String> LIST_VALUES = List.of("v1", "v2");
    private static final Map<String, List<String>> TEST_MAP = Map.of("lower", List.of("lower-value"), "Mixed", List.of("Mixed-value"), "UPPER", List.of("UPPER_value"), "LiSt", LIST_VALUES);
    private static final Map<String, List<String>> CHANGED_KEYS = Map.of("lower", List.of("lower".toUpperCase(Locale.ROOT), "Lower"), "Mixed", List.of("Mixed".toLowerCase(Locale.ROOT), "Mixed".toUpperCase(Locale.ROOT), "mIxEd"), "UPPER", List.of("UPPER".toLowerCase(Locale.ROOT), "Upper", "upper"), "LiSt", List.of("LiSt".toLowerCase(Locale.ROOT), "LiSt".toUpperCase(Locale.ROOT), "lIsT"));

    private CaseSensitivityTester() {
    }

    public static Map<String, List<String>> testMap() {
        return TEST_MAP;
    }

    public static <T> void testStrict(T dataStructure, BiFunction<T, String, Iterable<String>> valueGetter) {
        CaseSensitivityTester.test(dataStructure, valueGetter, true);
    }

    public static <T> void testLenient(T dataStructure, BiFunction<T, String, Iterable<String>> valueGetter) {
        CaseSensitivityTester.test(dataStructure, valueGetter, false);
    }

    private static <T> void test(T dataStructure, BiFunction<T, String, Iterable<String>> valueGetter, boolean isStrict) {
        for (Map.Entry<String, List<String>> entry : TEST_MAP.entrySet()) {
            String key = entry.getKey();
            Object[] expectedValue = TEST_MAP.get(key).toArray(new String[0]);
            MatcherAssert.assertThat((String)("Values found with key as-is '" + key + "'"), valueGetter.apply(dataStructure, key), (Matcher)Matchers.containsInAnyOrder((Object[])expectedValue));
        }
        for (Map.Entry<String, List<String>> changedKeyEntry : CHANGED_KEYS.entrySet()) {
            String validKey = changedKeyEntry.getKey();
            for (String changedKey : changedKeyEntry.getValue()) {
                MatcherAssert.assertThat((String)("Values found with key '" + validKey + "' altered to '" + changedKey + "'"), valueGetter.apply(dataStructure, changedKey), (Matcher)(isStrict ? Matchers.emptyIterable() : Matchers.containsInAnyOrder((Object[])TEST_MAP.get(validKey).toArray(new String[0]))));
            }
        }
    }
}

