/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.objectmapping;

import io.helidon.config.objectmapping.ReflectionUtil;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

interface HelidonMethodHandle {
    public static HelidonMethodHandle create(Class<?> type, Constructor<?> constructor) {
        return new ReflectionUtil.ConstructorMethodHandle(type, constructor);
    }

    public static HelidonMethodHandle create(Class<?> type, Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return new ReflectionUtil.StaticMethodHandle(method);
        }
        return new ReflectionUtil.InstanceMethodHandle(type, method);
    }

    public static HelidonMethodHandle create(Class<?> type, Field field) {
        return new ReflectionUtil.FieldMethodHandle(type, field);
    }

    public Object invoke(List<Object> var1);

    public MethodType type();

    default public Object invoke(Object ... params) {
        return this.invoke(Arrays.asList(params));
    }
}

