/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.objectmapping;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.objectmapping.HelidonMethodHandle;
import io.helidon.config.objectmapping.Transient;
import io.helidon.config.objectmapping.Value;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> REPLACED_TYPES = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtil.class.getName());
    private static final String METHOD_BUILDER = "builder";
    private static final String METHOD_BUILD = "build";
    private static final String CLASS_BUILDER = "Builder";

    private ReflectionUtil() {
    }

    static <T> Class<T> supportedType(Class<T> type) {
        return REPLACED_TYPES.getOrDefault(type, type);
    }

    static Optional<HelidonMethodHandle> findStaticMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = type.getMethod(methodName, parameterTypes);
            if (ReflectionUtil.checkMethod(method, true, type, methodName, parameterTypes.length > 0)) {
                return Optional.of(HelidonMethodHandle.create(type, method));
            }
            LOGGER.log(Level.FINEST, () -> "Class " + type.getName() + " method '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + " cannot be used.");
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINEST, ex, () -> "Class " + type.getName() + " does not have a method named '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + ".");
        }
        return Optional.empty();
    }

    static Optional<HelidonMethodHandle> findConstructor(Class<?> type, Class<?> ... parameterTypes) {
        try {
            Constructor<?> constructor = type.getConstructor(parameterTypes);
            if (ReflectionUtil.checkConstructor(constructor, parameterTypes.length > 0)) {
                return Optional.of(HelidonMethodHandle.create(type, constructor));
            }
            LOGGER.log(Level.FINEST, () -> "Class " + type.getName() + " constructor with parameters " + Arrays.toString(parameterTypes) + " cannot be used.");
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINEST, ex, () -> "Class " + type.getName() + " does not have a constructor with parameters " + Arrays.toString(parameterTypes) + ".");
        }
        return Optional.empty();
    }

    static <T> Optional<BuilderAccessor<T>> findBuilderMethod(Class<T> type) {
        return ReflectionUtil.findMethod(type, METHOD_BUILDER, true, null, new Class[0]).flatMap(builderMethod -> {
            HelidonMethodHandle builderHandler = HelidonMethodHandle.create(type, builderMethod);
            return ReflectionUtil.findBuilderBuildHandler(type, builderMethod.getReturnType()).map(buildHandler -> new BuilderAccessor(builderMethod.getReturnType(), builderHandler, type, (HelidonMethodHandle)buildHandler));
        });
    }

    static <T> Optional<BuilderAccessor<T>> findBuilderConstructor(Class<T> type) {
        Class<?>[] declaredClasses;
        for (Class<?> declaredClass : declaredClasses = type.getDeclaredClasses()) {
            if (!CLASS_BUILDER.equals(declaredClass.getSimpleName())) continue;
            return ReflectionUtil.findConstructor(declaredClass, new Class[0]).flatMap(constructor -> ReflectionUtil.findBuilderBuildHandler(type, declaredClass).map(buildHandler -> new BuilderAccessor(declaredClass, (HelidonMethodHandle)constructor, type, (HelidonMethodHandle)buildHandler)));
        }
        return Optional.empty();
    }

    static <T> Optional<FactoryAccessor<T>> findStaticMethodWithParameters(Class<T> type, String methodName) {
        AtomicReference<Method> foundMethod = new AtomicReference<Method>();
        for (Method method : type.getMethods()) {
            if (!ReflectionUtil.checkMethod(method, true, type, methodName, true)) continue;
            if (foundMethod.get() != null) {
                LOGGER.log(Level.WARNING, () -> "Class " + type.getName() + " contains more than one static factory method '" + methodName + "' with parameters. Any will be used to initialize the type.");
                return Optional.empty();
            }
            foundMethod.set(method);
        }
        if (foundMethod.get() == null) {
            return Optional.empty();
        }
        return ReflectionUtil.findStaticMethod(type, methodName, ((Method)foundMethod.get()).getParameterTypes()).map(handle -> new FactoryAccessor(type, (HelidonMethodHandle)handle, ((Method)foundMethod.get()).getParameters()));
    }

    static <T> Optional<FactoryAccessor<T>> findConstructorWithParameters(Class<T> type) {
        AtomicReference foundConstructor = new AtomicReference();
        for (Constructor<?> constructor : type.getConstructors()) {
            if (!ReflectionUtil.checkConstructor(constructor, true)) continue;
            if (foundConstructor.get() != null) {
                LOGGER.log(Level.WARNING, () -> "Class " + type.getName() + " contains more than one constructor with parameters. Any will be used to initialize the type.");
                return Optional.empty();
            }
            foundConstructor.set(constructor);
        }
        if (foundConstructor.get() == null) {
            return Optional.empty();
        }
        return ReflectionUtil.findConstructor(type, ((Constructor)foundConstructor.get()).getParameterTypes()).map(handle -> new FactoryAccessor(type, (HelidonMethodHandle)handle, ((Constructor)foundConstructor.get()).getParameters()));
    }

    static <T> Optional<HelidonMethodHandle> findBuilderBuildHandler(Class<T> type, Class<?> builderType) {
        return ReflectionUtil.findMethod(builderType, METHOD_BUILD, false, type, new Class[0]).map(it -> HelidonMethodHandle.create(type, it));
    }

    private static boolean checkConstructor(Constructor<?> constructor, boolean hasParams) {
        return Modifier.isPublic(constructor.getModifiers()) && !constructor.isAnnotationPresent(Transient.class) && constructor.getParameterCount() > 0 == hasParams;
    }

    private static boolean checkMethod(Method method, boolean isStatic, Class<?> returnType, String name, boolean hasParams) {
        return Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) == isStatic && !method.isAnnotationPresent(Transient.class) && method.getName().equals(name) && (returnType == null || returnType.isAssignableFrom(method.getReturnType())) && method.getParameterCount() > 0 == hasParams;
    }

    private static Optional<Method> findMethod(Class<?> type, String methodName, boolean isStatic, Class<?> returnType, Class<?> ... parameterTypes) {
        try {
            Method method = type.getMethod(methodName, parameterTypes);
            if (ReflectionUtil.checkMethod(method, isStatic, returnType, methodName, parameterTypes.length > 0)) {
                return Optional.of(method);
            }
            LOGGER.log(Level.FINEST, () -> "Class " + type.getName() + " method '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + " cannot be used.");
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINEST, ex, () -> "Class " + type.getName() + " does not have a method named '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + ".");
        }
        return Optional.empty();
    }

    static <T> BiFunction<Class<T>, Config, T> createDefaultSupplier(String name, Value annotation) {
        if (annotation != null) {
            if (!annotation.withDefaultSupplier().equals(Value.None.class)) {
                return (type, mapperManager) -> {
                    try {
                        return type.cast(annotation.withDefaultSupplier().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get());
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new ConfigException("Error creating default value supplier.", (Throwable)ex);
                    }
                };
            }
            if (!annotation.withDefault().equals("io.helidon.config:default=null")) {
                return (type, config) -> {
                    try {
                        return config.convert(type, annotation.withDefault());
                    }
                    catch (ConfigMappingException e) {
                        throw new ConfigMappingException(Config.Key.create((String)name), "Provided default value \"" + annotation.withDefault() + "\" cannot be converted to correct type \"" + type.getName() + "\"", (Throwable)e);
                    }
                };
            }
        }
        return null;
    }

    static <T> Collection<PropertyAccessor<?>> getBeanProperties(Class<T> type) {
        return ReflectionUtil.getPropertyAccessors(type).values();
    }

    static <T> Map<String, PropertyAccessor<?>> getPropertyAccessors(Class<T> type) {
        HashSet<String> transientProps = new HashSet<String>();
        HashMap propertyAccessors = new HashMap();
        ReflectionUtil.initMethods(type, transientProps, propertyAccessors);
        ReflectionUtil.initFields(type, transientProps, propertyAccessors);
        return propertyAccessors;
    }

    static <T> void initMethods(Class<T> type, Set<String> transientProps, Map<String, PropertyAccessor<?>> propertyAccessors) {
        for (Method method : type.getMethods()) {
            if (!ReflectionUtil.isSetter(type, method)) continue;
            String name = ReflectionUtil.propertyName(method);
            if (ReflectionUtil.isTransient(method, "single setter " + method.getName())) {
                transientProps.add(name);
                continue;
            }
            propertyAccessors.put(name, ReflectionUtil.createPropertyAccessor(type, name, method));
        }
    }

    static <T> void initFields(Class<T> type, Set<String> transientProps, Map<String, PropertyAccessor<?>> propertyAccessors) {
        for (Field field : type.getFields()) {
            if (!ReflectionUtil.isAccessible(field)) continue;
            String name = ReflectionUtil.propertyName(field, field::getName);
            if (ReflectionUtil.isTransient(field, "single field " + field.getName())) {
                if (!propertyAccessors.containsKey(name)) continue;
                throw new ConfigException("Illegal use of both @Value (method) and @Transient (field) annotations on single '" + name + "' property.");
            }
            if (transientProps.contains(name)) {
                if (!field.isAnnotationPresent(Value.class)) continue;
                throw new ConfigException("Illegal use of both @Value (field) and @Transient (method) annotations on single '" + name + "' property.");
            }
            if (propertyAccessors.containsKey(name)) {
                if (field.getAnnotation(Value.class) == null) continue;
                PropertyAccessor<?> propertyAccessor = propertyAccessors.get(name);
                if (propertyAccessor.hasValueAnnotation()) {
                    LOGGER.fine(() -> "Annotation @Value on '" + name + "' field is ignored because setter method already has one.");
                    continue;
                }
                propertyAccessor.setValueAnnotation(field.getAnnotation(Value.class));
                continue;
            }
            propertyAccessors.put(name, ReflectionUtil.createPropertyAccessor(type, name, field));
        }
    }

    static <T> PropertyAccessor<T> createPropertyAccessor(Class<T> type, String name, Method method) {
        Class propertyType = method.getParameterTypes()[0];
        Class configAsType = propertyType;
        boolean list = List.class.isAssignableFrom(configAsType);
        if (list) {
            Type genType = method.getGenericParameterTypes()[0];
            if (genType instanceof ParameterizedType) {
                configAsType = (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
            } else {
                throw new ConfigException("Unable to find generic type of List on setter parameter: " + method);
            }
        }
        return new PropertyAccessor(name, propertyType, configAsType, list, HelidonMethodHandle.create(type, method), method.getAnnotation(Value.class));
    }

    static <T> PropertyAccessor<T> createPropertyAccessor(Class<T> type, String name, Field field) {
        try {
            Class propertyType;
            Class configAsType = propertyType = field.getType();
            boolean list = List.class.isAssignableFrom(configAsType);
            if (list) {
                Type genType = field.getGenericType();
                if (genType instanceof ParameterizedType) {
                    configAsType = (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
                } else {
                    throw new ConfigException("Unable to find generic type of List on field type: " + field);
                }
            }
            return new PropertyAccessor(name, propertyType, configAsType, list, HelidonMethodHandle.create(type, field), field.getAnnotation(Value.class));
        }
        catch (ClassCastException ex) {
            throw new ConfigException("Cannot access field: " + field, (Throwable)ex);
        }
    }

    static boolean isTransient(AnnotatedElement annotated, String description) throws ConfigException {
        if (annotated.isAnnotationPresent(Transient.class)) {
            if (annotated.isAnnotationPresent(Value.class)) {
                throw new ConfigException("Illegal use of both @Value and @Transient annotations on '" + description + "'");
            }
            return true;
        }
        return false;
    }

    static boolean isAccessible(Field field) {
        return !Modifier.isFinal(field.getModifiers());
    }

    static boolean isSetter(Class<?> type, Method method) {
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (method.isAnnotationPresent(Value.class)) {
            return true;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return true;
        }
        return method.getReturnType().equals(type);
    }

    static String propertyName(Method method) {
        return Optional.ofNullable(method.getAnnotation(Value.class)).map(Value::key).filter(string -> !string.isEmpty()).orElseGet(() -> {
            String result = method.getName();
            if (result.startsWith("set") && result.length() > 3) {
                result = ReflectionUtil.decapitalize(result.substring("set".length()));
            }
            return result;
        });
    }

    static String propertyName(AnnotatedElement element, Supplier<String> nameSupplier) {
        return Optional.ofNullable(element.getAnnotation(Value.class)).map(Value::key).filter(key -> !key.isEmpty()).orElseGet(nameSupplier);
    }

    static String decapitalize(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static {
        REPLACED_TYPES.put(Byte.TYPE, Byte.class);
        REPLACED_TYPES.put(Short.TYPE, Short.class);
        REPLACED_TYPES.put(Integer.TYPE, Integer.class);
        REPLACED_TYPES.put(Long.TYPE, Long.class);
        REPLACED_TYPES.put(Float.TYPE, Float.class);
        REPLACED_TYPES.put(Double.TYPE, Double.class);
        REPLACED_TYPES.put(Boolean.TYPE, Boolean.class);
        REPLACED_TYPES.put(Character.TYPE, Character.class);
    }

    public static class InstanceMethodHandle
    implements HelidonMethodHandle {
        private Class<?> type;
        private final Method method;

        InstanceMethodHandle(Class<?> type, Method method) {
            this.type = type;
            this.method = method;
        }

        @Override
        public Object invoke(List<Object> params) {
            try {
                Object instance = params.get(0);
                ArrayList<Object> mutableParams = new ArrayList<Object>(params);
                mutableParams.remove(0);
                return this.method.invoke(params.get(0), mutableParams.toArray(new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Method " + this.method + " is not accessible. Cannot invoke", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigException("Failed to invoke method " + this.method, (Throwable)e);
            }
        }

        @Override
        public MethodType type() {
            ArrayList paramTypes = new ArrayList();
            paramTypes.add(this.type);
            paramTypes.addAll(Arrays.asList(this.method.getParameterTypes()));
            return MethodType.methodType(this.method.getReturnType(), paramTypes);
        }
    }

    static class ConstructorMethodHandle
    implements HelidonMethodHandle {
        private final Class<?> type;
        private final Constructor<?> constructor;

        ConstructorMethodHandle(Class<?> type, Constructor<?> constructor) {
            this.type = type;
            this.constructor = constructor;
        }

        @Override
        public Object invoke(List<Object> params) {
            try {
                return this.constructor.newInstance(params.toArray(new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Constructor " + this.constructor + " is not accessible. Cannot invoke", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigException("Failed to invoke constructor " + this.constructor, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ConfigException("Failed to instantiate class using constructor " + this.constructor, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Parameters mismatch for constructor " + this.constructor, (Throwable)e);
            }
        }

        @Override
        public MethodType type() {
            return MethodType.methodType(this.type);
        }
    }

    static class StaticMethodHandle
    implements HelidonMethodHandle {
        private final Method method;

        StaticMethodHandle(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(List<Object> params) {
            try {
                return this.method.invoke(null, params.toArray(new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Method " + this.method + " is not accessible. Cannot invoke", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigException("Failed to invoke method " + this.method, (Throwable)e);
            }
        }

        @Override
        public MethodType type() {
            return MethodType.methodType(this.method.getReturnType(), this.method.getParameterTypes());
        }
    }

    static class FieldMethodHandle
    implements HelidonMethodHandle {
        private final Field field;
        private final Class<?> type;

        FieldMethodHandle(Class<?> type, Field field) {
            this.type = type;
            this.field = field;
        }

        @Override
        public Object invoke(List<Object> params) {
            try {
                this.field.set(params.get(0), params.get(1));
                return null;
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Field " + this.field + " is not accessible. Cannot set value", (Throwable)e);
            }
        }

        @Override
        public MethodType type() {
            return MethodType.methodType(Void.class, this.type, this.field.getType());
        }
    }

    static class PropertyWrapper<T> {
        private final String name;
        private final Class<T> propertyType;
        private final Class<?> configAsType;
        private final boolean list;
        private BiFunction<Class<T>, Config, T> defaultSupplier;

        PropertyWrapper(String name, Class<T> propertyType, Class<?> configAsType, boolean list, BiFunction<Class<T>, Config, T> defaultSupplier) {
            this.name = name;
            this.propertyType = ReflectionUtil.supportedType(propertyType);
            this.configAsType = configAsType;
            this.list = list;
            this.defaultSupplier = defaultSupplier;
        }

        Optional<T> get(Config configNode) {
            try {
                if (configNode.exists()) {
                    if (this.list) {
                        return Optional.of(this.propertyType.cast(configNode.asList(this.configAsType).get()));
                    }
                    return Optional.of(this.propertyType.cast(configNode.as(this.configAsType).get()));
                }
                if (this.defaultSupplier != null) {
                    return Optional.ofNullable(this.defaultSupplier.apply(this.propertyType, configNode));
                }
                return Optional.empty();
            }
            catch (ConfigException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new ConfigException("Unable to set '" + this.name + "' property.", throwable);
            }
        }

        void setDefaultSupplier(BiFunction<Class<T>, Config, T> defaultSupplier) {
            this.defaultSupplier = defaultSupplier;
        }
    }

    static class PropertyAccessor<T> {
        private final String name;
        private final HelidonMethodHandle handle;
        private final boolean hasValueAnnotation;
        private final PropertyWrapper<T> propertyWrapper;

        PropertyAccessor(String name, Class<T> propertyType, Class<?> configAsType, boolean list, HelidonMethodHandle handle, Value value) {
            this.name = name;
            this.handle = handle;
            this.hasValueAnnotation = value != null;
            this.propertyWrapper = new PropertyWrapper<T>(name, propertyType, configAsType, list, ReflectionUtil.createDefaultSupplier(name, value));
        }

        public String name() {
            return this.name;
        }

        void set(Object instance, Config configNode) {
            this.propertyWrapper.get(configNode).ifPresent(value -> this.setImpl(instance, value));
        }

        private void setImpl(Object instance, Object value) {
            try {
                this.handle.invoke(instance, value);
            }
            catch (ConfigException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new ConfigException("Unable to set '" + this.name + "' property.", throwable);
            }
        }

        HelidonMethodHandle handle() {
            return this.handle;
        }

        boolean hasValueAnnotation() {
            return this.hasValueAnnotation;
        }

        void setValueAnnotation(Value value) {
            this.propertyWrapper.setDefaultSupplier(ReflectionUtil.createDefaultSupplier(this.name, value));
        }
    }

    static class BuilderAccessor<T> {
        private final Class<?> builderType;
        private final HelidonMethodHandle builderHandler;
        private final Class<T> buildType;
        private final HelidonMethodHandle buildHandler;
        private final Collection<PropertyAccessor<?>> builderAccessors;

        BuilderAccessor(Class<?> builderType, HelidonMethodHandle builderHandler, Class<T> buildType, HelidonMethodHandle buildHandler) {
            this.builderType = builderType;
            this.builderHandler = builderHandler;
            this.buildType = buildType;
            this.buildHandler = buildHandler;
            this.builderAccessors = ReflectionUtil.getBeanProperties(builderType);
        }

        public T create(Config config) {
            try {
                Object builder = this.builderType.cast(this.builderHandler.invoke(List.of()));
                for (PropertyAccessor<?> builderAccessor : this.builderAccessors) {
                    builderAccessor.set(builder, config.get(builderAccessor.name()));
                }
                return this.buildType.cast(this.buildHandler.invoke(List.of(builder)));
            }
            catch (ConfigMappingException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConfigMappingException(config.key(), this.buildType, "Builder java bean initialization has failed with an exception.", ex);
            }
        }
    }

    static class FactoryAccessor<T> {
        private final Class<T> type;
        private final HelidonMethodHandle handle;
        private final LinkedHashMap<String, PropertyWrapper<?>> parameterValueProviders;

        FactoryAccessor(Class<T> type, HelidonMethodHandle handle, Parameter[] parameters) {
            this.type = type;
            this.handle = handle;
            this.parameterValueProviders = FactoryAccessor.initParameterValueProviders(parameters);
        }

        public T create(Config configNode) {
            List<Object> args = this.createArguments(configNode);
            try {
                Object obj = this.handle.invoke(args);
                return this.type.cast(obj);
            }
            catch (ConfigException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new ConfigException("Unable to create '" + this.type.getName() + "' instance.", throwable);
            }
        }

        private List<Object> createArguments(Config configNode) {
            ArrayList<Object> arguments = new ArrayList<Object>(this.parameterValueProviders.size());
            this.parameterValueProviders.forEach((name, propertyWrapper) -> {
                Config subConfig = configNode.get(name);
                Object argument = propertyWrapper.get(subConfig).orElseThrow(() -> new ConfigMappingException(configNode.key(), this.type, "Missing value for parameter '" + name + "'."));
                arguments.add(argument);
            });
            return arguments;
        }

        private static LinkedHashMap<String, PropertyWrapper<?>> initParameterValueProviders(Parameter[] parameters) {
            LinkedHashMap parameterValueProvider = new LinkedHashMap();
            for (Parameter parameter : parameters) {
                String name = ReflectionUtil.propertyName(parameter, parameter::getName);
                parameterValueProvider.put(name, FactoryAccessor.createPropertyWrapper(name, parameter));
            }
            return parameterValueProvider;
        }

        private static PropertyWrapper<?> createPropertyWrapper(String name, Parameter parameter) {
            Value value = parameter.getAnnotation(Value.class);
            Class propertyType = parameter.getType();
            Class configAsType = propertyType;
            boolean list = List.class.isAssignableFrom(configAsType);
            if (list) {
                Type genType = parameter.getParameterizedType();
                if (genType instanceof ParameterizedType) {
                    configAsType = (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
                } else {
                    throw new ConfigException("Unable to find generic type of List on parameter type: " + parameter);
                }
            }
            return new PropertyWrapper(name, propertyType, configAsType, list, ReflectionUtil.createDefaultSupplier(name, value));
        }
    }
}

