/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.objectmapping;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.objectmapping.HelidonMethodHandle;
import io.helidon.config.objectmapping.ReflectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

class ObjectConfigMappers {
    ObjectConfigMappers() {
    }

    static class GenericConfigMapper<T>
    implements Function<Config, T> {
        private final Class<T> type;
        private final HelidonMethodHandle constructorHandle;
        private final Collection<ReflectionUtil.PropertyAccessor<?>> propertyAccessors;

        GenericConfigMapper(Class<T> type, HelidonMethodHandle constructorHandle) {
            this.type = type;
            this.constructorHandle = constructorHandle;
            this.propertyAccessors = ReflectionUtil.getBeanProperties(type);
            if (this.propertyAccessors.isEmpty()) {
                throw new IllegalArgumentException(type + " has no bean properties");
            }
        }

        @Override
        public T apply(Config config) throws ConfigMappingException, MissingValueException {
            try {
                T instance = this.type.cast(this.constructorHandle.invoke(List.of()));
                for (ReflectionUtil.PropertyAccessor<?> propertyAccessor : this.propertyAccessors) {
                    propertyAccessor.set(instance, config.get(propertyAccessor.name()));
                }
                return instance;
            }
            catch (ConfigMappingException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConfigMappingException(config.key(), this.type, "Generic java bean initialization has failed with an exception.", ex);
            }
        }
    }

    static class FactoryMethodConfigMapper<T>
    implements Function<Config, T> {
        private final ReflectionUtil.FactoryAccessor<T> factoryAccessor;

        FactoryMethodConfigMapper(ReflectionUtil.FactoryAccessor<T> factoryAccessor) {
            this.factoryAccessor = factoryAccessor;
        }

        @Override
        public T apply(Config config) throws ConfigMappingException, MissingValueException {
            return this.factoryAccessor.create(config);
        }
    }

    static class BuilderConfigMapper<T>
    implements Function<Config, T> {
        private final ReflectionUtil.BuilderAccessor<T> builderAccessor;

        BuilderConfigMapper(ReflectionUtil.BuilderAccessor<T> builderAccessor) {
            this.builderAccessor = builderAccessor;
        }

        @Override
        public T apply(Config config) throws ConfigMappingException, MissingValueException {
            return this.builderAccessor.create(config);
        }
    }

    static class StringMethodHandleConfigMapper<T>
    extends MethodHandleConfigMapper<T, String> {
        StringMethodHandleConfigMapper(Class<T> type, String methodName, HelidonMethodHandle methodHandle) {
            super(type, methodName, methodHandle);
        }

        @Override
        protected String invokeParameter(Config config) {
            return (String)config.asString().get();
        }
    }

    static class ConfigMethodHandleConfigMapper<T>
    extends MethodHandleConfigMapper<T, Config> {
        ConfigMethodHandleConfigMapper(Class<T> type, String methodName, HelidonMethodHandle methodHandle) {
            super(type, methodName, methodHandle);
        }

        @Override
        protected Config invokeParameter(Config config) {
            return config;
        }
    }

    static abstract class MethodHandleConfigMapper<T, P>
    implements Function<Config, T> {
        private final Class<T> type;
        private final String methodName;
        private final HelidonMethodHandle methodHandle;

        MethodHandleConfigMapper(Class<T> type, String methodName, HelidonMethodHandle methodHandle) {
            this.type = type;
            this.methodName = methodName;
            this.methodHandle = methodHandle;
        }

        protected abstract P invokeParameter(Config var1);

        @Override
        public T apply(Config config) throws ConfigMappingException, MissingValueException {
            try {
                return this.type.cast(this.methodHandle.invoke(List.of(this.invokeParameter(config))));
            }
            catch (ConfigMappingException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConfigMappingException(config.key(), this.type, "Invocation of " + this.methodName + " has failed with an exception.", ex);
            }
        }
    }
}

