/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.types.TypeName;
import io.helidon.config.metadata.processor.ConfiguredAnnotation;
import io.helidon.config.metadata.processor.ConfiguredOptionData;
import io.helidon.metadata.hson.Hson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class ConfiguredType {
    private final Set<ConfiguredProperty> allProperties = new HashSet<ConfiguredProperty>();
    private final List<ProducerMethod> producerMethods = new LinkedList<ProducerMethod>();
    private final TypeName targetClass;
    private final TypeName annotatedClass;
    private final List<TypeName> inherited = new LinkedList<TypeName>();
    private final ConfiguredAnnotation configured;

    ConfiguredType(ConfiguredAnnotation configured, TypeName annotatedClass, TypeName targetClass, boolean typeDefinition) {
        this.annotatedClass = annotatedClass;
        this.targetClass = targetClass;
        this.configured = configured;
    }

    ConfiguredType addProducer(ProducerMethod producer) {
        this.producerMethods.add(producer);
        return this;
    }

    ConfiguredType addProperty(ConfiguredProperty property) {
        this.allProperties.add(property);
        return this;
    }

    List<ProducerMethod> producers() {
        return this.producerMethods;
    }

    Set<ConfiguredProperty> properties() {
        return this.allProperties;
    }

    String targetClass() {
        return this.targetClass.fqName();
    }

    String annotatedClass() {
        return this.annotatedClass.fqName();
    }

    boolean standalone() {
        return this.configured.root();
    }

    String prefix() {
        return this.configured.prefix().orElse(null);
    }

    void write(List<Hson.Struct> typeArray) {
        Hson.Struct.Builder typeObject = Hson.Struct.builder();
        typeObject.set("type", this.targetClass());
        typeObject.set("annotatedType", this.annotatedClass());
        if (this.standalone()) {
            typeObject.set("standalone", true);
        }
        this.configured.prefix().ifPresent(it -> typeObject.set("prefix", it));
        this.configured.description().ifPresent(it -> typeObject.set("description", it));
        if (!this.inherited.isEmpty()) {
            typeObject.setStrings("inherits", this.inherited.stream().map(rec$ -> ((TypeName)rec$).fqName()).toList());
        }
        if (!this.configured.provides().isEmpty()) {
            typeObject.setStrings("provides", this.configured.provides());
        }
        if (!this.producerMethods.isEmpty()) {
            typeObject.setStrings("producers", this.producerMethods.stream().map(Object::toString).collect(Collectors.toList()));
        }
        ArrayList<Hson.Struct> options = new ArrayList<Hson.Struct>();
        for (ConfiguredProperty property : this.allProperties) {
            this.writeProperty(options, "", property);
        }
        typeObject.setStructs("options", options);
        typeArray.add((Hson.Struct)typeObject.build());
    }

    public String toString() {
        return this.targetClass.fqName();
    }

    void addInherited(TypeName classOrIface) {
        this.inherited.add(classOrIface);
    }

    private static String paramsToString(List<TypeName> params) {
        return params.stream().map(rec$ -> ((TypeName)rec$).resolvedName()).collect(Collectors.joining(", "));
    }

    private void writeProperty(List<Hson.Struct> optionsBuilder, String prefix, ConfiguredProperty property) {
        String method;
        Hson.Struct.Builder optionBuilder = Hson.Struct.builder();
        if (property.key() != null && !property.key.isBlank()) {
            optionBuilder.set("key", this.prefix(prefix, property.key()));
        }
        if (!"java.lang.String".equals(property.type)) {
            optionBuilder.set("type", property.type());
        }
        optionBuilder.set("description", property.description());
        if (property.defaultValue() != null) {
            optionBuilder.set("defaultValue", property.defaultValue());
        }
        if (property.experimental) {
            optionBuilder.set("experimental", true);
        }
        if (!property.optional) {
            optionBuilder.set("required", true);
        }
        if (!property.kind().equals("VALUE")) {
            optionBuilder.set("kind", property.kind());
        }
        if (property.provider) {
            optionBuilder.set("provider", true);
            optionBuilder.set("providerType", property.providerType.fqName());
        }
        if (property.deprecated()) {
            optionBuilder.set("deprecated", true);
        }
        if (property.merge()) {
            optionBuilder.set("merge", true);
        }
        if ((method = property.builderMethod()) != null) {
            optionBuilder.set("method", method);
        }
        if (property.configuredType != null) {
            String finalPrefix = property.kind().equals("LIST") ? this.prefix(this.prefix(prefix, property.key()), "*") : this.prefix(prefix, property.key());
            property.configuredType.properties().forEach(it -> this.writeProperty(optionsBuilder, finalPrefix, (ConfiguredProperty)it));
        }
        if (!property.allowedValues.isEmpty()) {
            ArrayList<Hson.Struct> allowedValues = new ArrayList<Hson.Struct>();
            for (ConfiguredOptionData.AllowedValue allowedValue : property.allowedValues) {
                allowedValues.add((Hson.Struct)Hson.Struct.builder().set("value", allowedValue.value()).set("description", allowedValue.description()).build());
            }
            optionBuilder.setStructs("allowedValues", allowedValues);
        }
        optionsBuilder.add((Hson.Struct)optionBuilder.build());
    }

    private String prefix(String currentPrefix, String newSuffix) {
        if (currentPrefix.isEmpty()) {
            return newSuffix;
        }
        return currentPrefix + "." + newSuffix;
    }

    static final class ConfiguredProperty {
        private final String builderMethod;
        private final String key;
        private final String description;
        private final String defaultValue;
        private final String type;
        private final boolean experimental;
        private final boolean optional;
        private final String kind;
        private final boolean provider;
        private final TypeName providerType;
        private final boolean deprecated;
        private final boolean merge;
        private final List<ConfiguredOptionData.AllowedValue> allowedValues;
        private ConfiguredType configuredType;

        ConfiguredProperty(String builderMethod, String key, String description, String defaultValue, TypeName type, boolean experimental, boolean optional, String kind, boolean provider, TypeName providerType, boolean deprecated, boolean merge, List<ConfiguredOptionData.AllowedValue> allowedValues) {
            this.builderMethod = builderMethod;
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type.fqName();
            this.experimental = experimental;
            this.optional = optional;
            this.kind = kind;
            this.provider = provider;
            this.providerType = providerType == null ? type : providerType;
            this.deprecated = deprecated;
            this.merge = merge;
            this.allowedValues = allowedValues;
        }

        String builderMethod() {
            return this.builderMethod;
        }

        String key() {
            return this.key;
        }

        String description() {
            return this.description;
        }

        String defaultValue() {
            return this.defaultValue;
        }

        String type() {
            return this.type;
        }

        boolean experimental() {
            return this.experimental;
        }

        boolean optional() {
            return this.optional;
        }

        String kind() {
            return this.kind;
        }

        boolean deprecated() {
            return this.deprecated;
        }

        boolean merge() {
            return this.merge;
        }

        void nestedType(ConfiguredType nested) {
            this.configuredType = nested;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfiguredProperty that = (ConfiguredProperty)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return this.key;
        }
    }

    static final class ProducerMethod {
        private final boolean isStatic;
        private final TypeName owningClass;
        private final String methodName;
        private final List<TypeName> methodParams;

        ProducerMethod(boolean isStatic, TypeName owningClass, String methodName, List<TypeName> methodParams) {
            this.isStatic = isStatic;
            this.owningClass = owningClass;
            this.methodName = methodName;
            this.methodParams = methodParams;
        }

        public String toString() {
            return this.owningClass.fqName() + "#" + this.methodName + "(" + ConfiguredType.paramsToString(this.methodParams) + ")";
        }
    }
}

