/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.processor.ElementInfoPredicates;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.processor.ConfiguredOptionData;
import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.TypeHandlerBase;
import io.helidon.config.metadata.processor.TypeHandlerMetaApiBase;
import io.helidon.config.metadata.processor.UsedTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.processing.Messager;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

final class BlueprintUtil {
    private BlueprintUtil() {
    }

    static void addInterfaces(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        for (TypeInfo interfaceInfo : typeInfo.interfaceTypeInfo()) {
            if (interfaceInfo.hasAnnotation(requiredAnnotation)) {
                TypeName ifaceTypeName = interfaceInfo.typeName();
                if (interfaceInfo.hasAnnotation(UsedTypes.BLUEPRINT)) {
                    String className = ifaceTypeName.className();
                    if (className.endsWith("Blueprint")) {
                        className = className.substring(0, className.length() - "Blueprint".length());
                    }
                    ifaceTypeName = ((TypeName.Builder)TypeName.builder((TypeName)ifaceTypeName).className(className)).build();
                }
                type.addInherited(ifaceTypeName);
                continue;
            }
            BlueprintUtil.addSuperClasses(type, interfaceInfo, requiredAnnotation);
        }
    }

    static TypeName targetType(TypeInfo blueprint, TypeName prototype) {
        return blueprint.interfaceTypeInfo().stream().map(rec$ -> ((TypeInfo)rec$).typeName()).filter(it -> UsedTypes.PROTOTYPE_FACTORY.equals((Object)it.genericTypeName())).filter(it -> it.typeArguments().size() == 1).map(it -> (TypeName)it.typeArguments().get(0)).findAny().orElse(prototype);
    }

    static TypeName prototype(TypeName blueprintType) {
        String className = blueprintType.className();
        if (className.endsWith("Blueprint")) {
            className = className.substring(0, className.length() - "Blueprint".length());
        }
        return ((TypeName.Builder)TypeName.builder((TypeName)blueprintType).className(className)).build().genericTypeName();
    }

    static void processBlueprint(TypeInfo blueprint, ConfiguredType type, TypeName prototype, TypeName targetType, TypeName requiredOptionAnnotation, Consumer<TypedElementInfo> methodHandler) {
        type.addProducer(new ConfiguredType.ProducerMethod(true, prototype, "create", List.of(UsedTypes.COMMON_CONFIG)));
        type.addProducer(new ConfiguredType.ProducerMethod(true, prototype, "builder", List.of()));
        if (!targetType.equals((Object)prototype)) {
            type.addProducer(new ConfiguredType.ProducerMethod(false, targetType, "create", List.of(prototype)));
        }
        blueprint.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(TypeHandlerBase.isMine(blueprint.typeName())).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isDefault)).filter(ElementInfoPredicates.hasAnnotation((TypeName)requiredOptionAnnotation)).forEach(methodHandler);
    }

    static TypeHandlerMetaApiBase.OptionType typeForBlueprintFromSignature(Messager aptMessager, Elements aptElements, TypedElementInfo element, ConfiguredOptionData annotation) {
        if (!ElementInfoPredicates.hasNoArgs((TypedElementInfo)element)) {
            aptMessager.printMessage(Diagnostic.Kind.ERROR, "Method " + String.valueOf(element) + " is annotated with @Configured, yet it has a parameter. Interface methods must not have parameters.", TypeHandlerBase.elementFor(aptElements, element));
            throw new IllegalStateException("Could not determine property type");
        }
        TypeName returnType = element.typeName();
        if (ElementInfoPredicates.isVoid((TypedElementInfo)element)) {
            aptMessager.printMessage(Diagnostic.Kind.ERROR, "Method " + String.valueOf(element) + " is annotated with @Configured, yet it is void. Interface methods must return the property type.", TypeHandlerBase.elementFor(aptElements, element));
            throw new IllegalStateException("Could not determine property type");
        }
        if (returnType.isOptional()) {
            if (!(returnType.isMap() || returnType.isSet() || returnType.isList())) {
                return new TypeHandlerMetaApiBase.OptionType((TypeName)returnType.typeArguments().get(0), "VALUE");
            }
            returnType = (TypeName)returnType.typeArguments().get(0);
        }
        if (returnType.isList() || returnType.isSet()) {
            return new TypeHandlerMetaApiBase.OptionType((TypeName)returnType.typeArguments().get(0), "LIST");
        }
        if (returnType.isMap()) {
            return new TypeHandlerMetaApiBase.OptionType((TypeName)returnType.typeArguments().get(1), "MAP");
        }
        return new TypeHandlerMetaApiBase.OptionType(returnType.boxed(), annotation.kind());
    }

    private static void addSuperClasses(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        Optional foundSuperType = typeInfo.superTypeInfo();
        if (foundSuperType.isEmpty()) {
            return;
        }
        TypeInfo superClass = (TypeInfo)foundSuperType.get();
        while (true) {
            if (superClass.hasAnnotation(requiredAnnotation)) {
                type.addInherited(superClass.typeName());
                return;
            }
            foundSuperType = superClass.superTypeInfo();
            if (foundSuperType.isEmpty()) {
                return;
            }
            superClass = (TypeInfo)foundSuperType.get();
        }
    }
}

