/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.processor.BlueprintUtil;
import io.helidon.config.metadata.processor.ConfiguredAnnotation;
import io.helidon.config.metadata.processor.ConfiguredOptionData;
import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.TypeHandler;
import io.helidon.config.metadata.processor.TypeHandlerMetaApiBase;
import io.helidon.config.metadata.processor.TypeHandlerResult;
import io.helidon.config.metadata.processor.UsedTypes;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;

class TypeHandlerMetaApiBlueprint
extends TypeHandlerMetaApiBase
implements TypeHandler {
    private final TypeInfo blueprint;
    private final TypeName blueprintType;

    TypeHandlerMetaApiBlueprint(ProcessingEnvironment aptEnv, TypeInfo blueprint) {
        super(aptEnv);
        this.blueprint = blueprint;
        this.blueprintType = blueprint.typeName();
    }

    @Override
    public TypeHandlerResult handle() {
        TypeName prototype = BlueprintUtil.prototype(this.blueprintType);
        TypeName builderType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)prototype).className("Builder")).addEnclosingName(prototype.className())).build();
        TypeName targetType = BlueprintUtil.targetType(this.blueprint, prototype);
        String module = this.blueprint.module().orElse("unknown");
        ConfiguredAnnotation configured = ConfiguredAnnotation.createMeta(this.blueprint.annotation(UsedTypes.META_CONFIGURED));
        ConfiguredType type = new ConfiguredType(configured, prototype, targetType, true);
        this.addInterfaces(type, this.blueprint, UsedTypes.META_CONFIGURED);
        BlueprintUtil.processBlueprint(this.blueprint, type, prototype, targetType, UsedTypes.META_OPTION, it -> this.processBuilderMethod(builderType, type, (TypedElementInfo)it, this::optionType, this::builderMethodParams));
        return new TypeHandlerResult(targetType, module, type);
    }

    @Override
    void addInterfaces(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        BlueprintUtil.addInterfaces(type, typeInfo, requiredAnnotation);
    }

    private List<TypeName> builderMethodParams(TypedElementInfo elementInfo, TypeHandlerMetaApiBase.OptionType type) {
        return List.of(type.elementType());
    }

    private TypeHandlerMetaApiBase.OptionType optionType(TypedElementInfo elementInfo, ConfiguredOptionData configuredOption) {
        if (configuredOption.type() == null || configuredOption.type().equals((Object)UsedTypes.META_OPTION)) {
            return BlueprintUtil.typeForBlueprintFromSignature(this.aptMessager(), this.aptElements(), elementInfo, configuredOption);
        }
        return new TypeHandlerMetaApiBase.OptionType(configuredOption.type(), configuredOption.kind());
    }
}

