/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.processor.ElementInfoPredicates;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.processor.ConfiguredAnnotation;
import io.helidon.config.metadata.processor.ConfiguredOptionData;
import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.TypeHandler;
import io.helidon.config.metadata.processor.TypeHandlerBase;
import io.helidon.config.metadata.processor.TypeHandlerMetaApiBase;
import io.helidon.config.metadata.processor.TypeHandlerResult;
import io.helidon.config.metadata.processor.UsedTypes;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

class TypeHandlerMetaApi
extends TypeHandlerMetaApiBase
implements TypeHandler {
    private final TypeInfo typeInfo;
    private final TypeName typeName;

    TypeHandlerMetaApi(ProcessingEnvironment aptEnv, TypeInfo typeInfo) {
        super(aptEnv);
        this.typeInfo = typeInfo;
        this.typeName = typeInfo.typeName();
    }

    @Override
    public TypeHandlerResult handle() {
        String module;
        boolean isBuilder;
        TypeInfo targetType;
        Optional<TypeName> foundTarget = this.findBuilderTarget(new HashSet<TypeName>(), this.typeInfo);
        ConfiguredAnnotation configured = ConfiguredAnnotation.createMeta(this.typeInfo.annotation(UsedTypes.META_CONFIGURED));
        if (!configured.ignoreBuildMethod() && !this.typeInfo.modifiers().contains("abstract") && foundTarget.isPresent()) {
            TypeName targetTypeName = foundTarget.get();
            targetType = this.typeInfo(targetTypeName, ElementInfoPredicates::isMethod).orElseThrow(() -> new IllegalStateException("Cannot find target type info for type " + targetTypeName.fqName() + ", discovered for type: " + this.typeInfo.typeName().fqName()));
            isBuilder = true;
            module = targetType.module().orElse("unknown");
        } else {
            targetType = this.typeInfo;
            isBuilder = false;
            module = this.typeInfo.module().orElse("unknown");
        }
        ConfiguredType type = new ConfiguredType(configured, this.typeName, targetType.typeName(), false);
        this.addSuperClasses(type, this.typeInfo, UsedTypes.META_CONFIGURED);
        this.addInterfaces(type, this.typeInfo, UsedTypes.META_CONFIGURED);
        if (isBuilder) {
            this.processBuilderType(this.typeInfo, type, this.typeName, targetType);
        } else {
            this.processTargetType(this.typeInfo, type, this.typeName, type.standalone());
        }
        return new TypeHandlerResult(targetType.typeName(), module, type);
    }

    private void processTargetType(TypeInfo typeInfo, ConfiguredType type, TypeName typeName, boolean standalone) {
        List<TypedElementInfo> methods = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates::isStatic).toList();
        boolean isTargetType = false;
        LinkedList<TypedElementInfo> validMethods = new LinkedList<TypedElementInfo>();
        TypedElementInfo configCreator = null;
        for (TypedElementInfo method : methods) {
            String name = method.elementName();
            if ("create".equals(name)) {
                TypeName paramType;
                if (!method.typeName().genericTypeName().equals((Object)typeName.genericTypeName())) continue;
                validMethods.add(method);
                List parameters = method.parameterArguments();
                if (parameters.size() == 1 && ((paramType = ((TypedElementInfo)parameters.get(0)).typeName()).equals((Object)UsedTypes.CONFIG) || paramType.equals((Object)UsedTypes.COMMON_CONFIG))) {
                    configCreator = method;
                }
                isTargetType = true;
                continue;
            }
            if (!name.equals("builder")) continue;
            this.aptMessager().printMessage(Diagnostic.Kind.ERROR, "Type " + typeName.fqName() + " is marked with @Configured, yet it has a static builder() method. Please mark the builder instead of this class.", this.aptElements().getTypeElement(typeName.fqName()));
        }
        if (isTargetType) {
            if (configCreator != null) {
                type.addProducer(new ConfiguredType.ProducerMethod(true, typeName, configCreator.elementName(), this.params(configCreator)));
            }
            for (TypedElementInfo validMethod : validMethods) {
                List<ConfiguredOptionData> options = this.findConfiguredOptionAnnotations(validMethod);
                if (options.isEmpty()) continue;
                for (ConfiguredOptionData data : options) {
                    TypeElement typeElement;
                    if ((data.name() == null || data.name().isBlank()) && !data.merge()) {
                        typeElement = this.aptElements().getTypeElement(typeName.fqName());
                        this.aptMessager().printMessage(Diagnostic.Kind.ERROR, "ConfiguredOption on " + String.valueOf(typeElement) + "." + String.valueOf(validMethod) + " does not have value defined. It is mandatory on non-builder methods", typeElement);
                        return;
                    }
                    if (data.description() == null || data.description().isBlank()) {
                        typeElement = this.aptElements().getTypeElement(typeName.fqName());
                        this.aptMessager().printMessage(Diagnostic.Kind.ERROR, "ConfiguredOption on " + String.valueOf(typeElement) + "." + String.valueOf(validMethod) + " does not have description defined. It is mandatory on non-builder methods", typeElement);
                        return;
                    }
                    if (data.type() == null) {
                        data.type(TypeNames.STRING);
                    }
                    ConfiguredType.ConfiguredProperty prop = new ConfiguredType.ConfiguredProperty(null, data.name(), data.description(), data.defaultValue(), data.type(), data.experimental(), data.optional(), data.kind(), data.provider(), data.providerType(), data.deprecated(), data.merge(), data.allowedValues());
                    type.addProperty(prop);
                }
            }
        } else {
            if (standalone) {
                this.aptMessager().printMessage(Diagnostic.Kind.ERROR, "Type " + typeName.fqName() + " is marked as standalone configuration unit, yet it does have neither a builder method, nor a create method");
                return;
            }
            typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(TypeHandlerMetaApiBase.isMine(typeName)).forEach(it -> this.processBuilderMethod(typeName, type, (TypedElementInfo)it));
        }
    }

    private void processBuilderType(TypeInfo typeInfo, ConfiguredType type, TypeName typeName, TypeInfo targetType) {
        type.addProducer(new ConfiguredType.ProducerMethod(false, typeName, "build", List.of()));
        TypeName targetTypeName = targetType.typeName();
        if (targetType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates.elementName((String)"create")).filter(TypeHandlerBase::hasConfigParam).anyMatch(TypeHandlerMetaApiBase.isMine(targetTypeName))) {
            type.addProducer(new ConfiguredType.ProducerMethod(true, targetTypeName, "create", List.of(UsedTypes.COMMON_CONFIG)));
        }
        typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(TypeHandlerMetaApiBase.isMine(typeName)).filter(it -> it.hasAnnotation(UsedTypes.META_OPTION) || it.hasAnnotation(UsedTypes.META_OPTIONS)).forEach(it -> this.processBuilderMethod(typeName, type, (TypedElementInfo)it));
    }

    private List<TypeName> builderMethodParams(TypedElementInfo elementInfo, TypeHandlerMetaApiBase.OptionType type) {
        return this.params(elementInfo);
    }

    private void processBuilderMethod(TypeName typeName, ConfiguredType configuredType, TypedElementInfo elementInfo) {
        this.processBuilderMethod(typeName, configuredType, elementInfo, this::optionType, this::builderMethodParams);
    }

    private TypeHandlerMetaApiBase.OptionType optionType(TypedElementInfo elementInfo, ConfiguredOptionData annotation) {
        if (annotation.type() == null || annotation.type().equals((Object)UsedTypes.META_OPTION)) {
            List parameters = elementInfo.parameterArguments();
            if (parameters.size() != 1) {
                this.aptMessager().printMessage(Diagnostic.Kind.ERROR, "Method " + elementInfo.elementName() + " is annotated with @ConfiguredOption, yet it does not have explicit type, or exactly one parameter", this.aptElements().getTypeElement(elementInfo.enclosingType().map(rec$ -> ((TypeName)rec$).fqName()).orElse(null)));
                return new TypeHandlerMetaApiBase.OptionType(TypeNames.STRING, "VALUE");
            }
            TypedElementInfo parameter = (TypedElementInfo)parameters.iterator().next();
            TypeName paramType = parameter.typeName();
            if (paramType.isList() || paramType.isSet()) {
                return new TypeHandlerMetaApiBase.OptionType((TypeName)paramType.typeArguments().get(0), "LIST");
            }
            if (paramType.isMap()) {
                return new TypeHandlerMetaApiBase.OptionType((TypeName)paramType.typeArguments().get(1), "MAP");
            }
            return new TypeHandlerMetaApiBase.OptionType(paramType.boxed(), annotation.kind());
        }
        return new TypeHandlerMetaApiBase.OptionType(annotation.type(), annotation.kind());
    }

    private Optional<TypeName> findBuilderTarget(Set<TypeName> processed, TypeInfo typeInfo) {
        return typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(ElementInfoPredicates::hasNoArgs).filter(ElementInfoPredicates.elementName((String)"build")).filter(Predicate.not(ElementInfoPredicates::isVoid)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).findFirst().map(it -> it.typeName());
    }
}

