/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.processor.BlueprintUtil;
import io.helidon.config.metadata.processor.ConfiguredAnnotation;
import io.helidon.config.metadata.processor.ConfiguredOptionData;
import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.TypeHandler;
import io.helidon.config.metadata.processor.TypeHandlerBase;
import io.helidon.config.metadata.processor.TypeHandlerMetaApiBase;
import io.helidon.config.metadata.processor.TypeHandlerResult;
import io.helidon.config.metadata.processor.UsedTypes;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;

class TypeHandlerBuilderApi
extends TypeHandlerBase
implements TypeHandler {
    private final TypeInfo blueprint;
    private final TypeName blueprintType;

    TypeHandlerBuilderApi(ProcessingEnvironment aptEnv, TypeInfo blueprint) {
        super(aptEnv);
        this.blueprint = blueprint;
        this.blueprintType = blueprint.typeName();
    }

    @Override
    public TypeHandlerResult handle() {
        TypeName prototype = BlueprintUtil.prototype(this.blueprintType);
        TypeName builderType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)prototype).className("Builder")).addEnclosingName(prototype.className())).build();
        TypeName targetType = BlueprintUtil.targetType(this.blueprint, prototype);
        String module = this.blueprint.module().orElse("unknown");
        ConfiguredAnnotation configured = ConfiguredAnnotation.createBuilder(this.blueprint);
        ConfiguredType type = new ConfiguredType(configured, prototype, targetType, true);
        this.addInterfaces(type, this.blueprint, UsedTypes.CONFIGURED);
        BlueprintUtil.processBlueprint(this.blueprint, type, prototype, targetType, UsedTypes.OPTION_CONFIGURED, it -> this.processBlueprintMethod(builderType, type, (TypedElementInfo)it));
        return new TypeHandlerResult(targetType, module, type);
    }

    @Override
    void addInterfaces(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        BlueprintUtil.addInterfaces(type, typeInfo, requiredAnnotation);
    }

    private void processBlueprintMethod(TypeName typeName, ConfiguredType configuredType, TypedElementInfo elementInfo) {
        ConfiguredOptionData data = ConfiguredOptionData.createBuilder(elementInfo);
        String name = this.key(elementInfo, data);
        String description = this.description(elementInfo, data);
        String defaultValue = this.defaultValue(data.defaultValue());
        boolean experimental = data.experimental();
        TypeHandlerMetaApiBase.OptionType type = BlueprintUtil.typeForBlueprintFromSignature(this.aptMessager(), this.aptElements(), elementInfo, data);
        boolean optional = defaultValue != null || data.optional();
        boolean deprecated = data.deprecated();
        List<ConfiguredOptionData.AllowedValue> allowedValues = this.allowedValues(data, type.elementType());
        List<TypeName> paramTypes = List.of(elementInfo.typeName());
        ConfiguredType.ProducerMethod builderMethod = new ConfiguredType.ProducerMethod(false, typeName, elementInfo.elementName(), paramTypes);
        ConfiguredType.ConfiguredProperty property = new ConfiguredType.ConfiguredProperty(builderMethod.toString(), name, description, defaultValue, type.elementType(), experimental, optional, type.kind(), data.provider(), data.providerType(), deprecated, data.merge(), allowedValues);
        configuredType.addProperty(property);
    }
}

