/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.JArray;
import io.helidon.config.metadata.processor.JObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

class ConfigMetadataHandler {
    private static final String META_FILE = "META-INF/helidon/config-metadata.json";
    private static final Pattern JAVADOC_CODE = Pattern.compile("\\{@code (.*?)}");
    private static final Pattern JAVADOC_LINK = Pattern.compile("\\{@link (.*?)}");
    private static final String ANNOTATIONS_PACKAGE = "io.helidon.config.metadata.";
    private static final String UNCONFIGURED_OPTION = "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED";
    private static final String CONFIGURED_CLASS = "io.helidon.config.metadata.Configured";
    private static final String CONFIGURED_OPTION_CLASS = "io.helidon.config.metadata.ConfiguredOption";
    private static final String CONFIGURED_OPTIONS_CLASS = "io.helidon.config.metadata.ConfiguredOptions";
    private final Map<String, ConfiguredType> newOptions = new HashMap<String, ConfiguredType>();
    private final Map<String, List<String>> moduleTypes = new HashMap<String, List<String>>();
    private Elements elementUtils;
    private Messager messager;
    private TypeElement configuredElement;
    private Filer filer;
    private Types typeUtils;
    private TypeMirror builderType;
    private TypeMirror configType;
    private TypeMirror erasedListType;
    private TypeMirror erasedIterableType;
    private TypeMirror erasedSetType;
    private TypeMirror erasedMapType;

    ConfigMetadataHandler() {
    }

    synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.configuredElement = this.elementUtils.getTypeElement(CONFIGURED_CLASS);
        this.builderType = this.elementUtils.getTypeElement("io.helidon.common.Builder").asType();
        this.configType = this.elementUtils.getTypeElement("io.helidon.config.Config").asType();
        this.erasedListType = this.typeUtils.erasure(this.elementUtils.getTypeElement(List.class.getName()).asType());
        this.erasedSetType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Set.class.getName()).asType());
        this.erasedIterableType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Iterable.class.getName()).asType());
        this.erasedMapType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Map.class.getName()).asType());
    }

    boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.doProcess(roundEnv);
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process config metadata annotation processor. " + this.toMessage(e));
            e.printStackTrace();
            return false;
        }
    }

    private boolean doProcess(RoundEnvironment roundEnv) {
        Set<? extends Element> classes = roundEnv.getElementsAnnotatedWith(this.configuredElement);
        for (Element element : classes) {
            this.processClass(element);
        }
        if (roundEnv.processingOver()) {
            this.storeMetadata();
        }
        return false;
    }

    private void processClass(Element aClass) {
        this.findAnnotation(aClass, CONFIGURED_CLASS).ifPresent(it -> this.processConfiguredAnnotation(aClass, (AnnotationMirror)it));
    }

    private Optional<AnnotationMirror> findAnnotation(Element annotatedElement, String annotationType) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().toString().equals(annotationType)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    private void processConfiguredAnnotation(Element aClass, AnnotationMirror mirror) {
        String className;
        boolean standalone = this.findValue(mirror, "root", Boolean.class, false);
        String keyPrefix = this.findValue(mirror, "prefix", String.class, "");
        String description = this.findValue(mirror, "description", String.class, "");
        boolean ignoreBuildMethod = this.findValue(mirror, "ignoreBuildMethod", Boolean.class, false);
        String targetClass = className = aClass.toString();
        boolean isBuilder = false;
        TypeElement classElement = (TypeElement)aClass;
        if (!ignoreBuildMethod && this.typeUtils.isAssignable(this.typeUtils.erasure(aClass.asType()), this.typeUtils.erasure(this.builderType))) {
            BuilderTypeInfo foundBuilder = this.findBuilder(classElement);
            isBuilder = foundBuilder.isBuilder;
            if (isBuilder) {
                targetClass = foundBuilder.targetClass;
            }
        }
        ConfiguredType type = new ConfiguredType(className, targetClass, standalone, keyPrefix, description, this.toProvides(aClass));
        this.newOptions.put(targetClass, type);
        String module = this.elementUtils.getModuleOf(aClass).toString();
        this.moduleTypes.computeIfAbsent(module, it -> new LinkedList()).add(targetClass);
        this.addSuperClasses(type, classElement);
        this.addInterfaces(type, classElement);
        if (isBuilder) {
            this.processBuilderType(classElement, type, className, targetClass);
        } else {
            this.processTargetType(classElement, type, className, standalone);
        }
    }

    private <T> T findValue(AnnotationMirror annotationMirror, String name, Class<T> type, T defaultValue) {
        return (T)this.findValue(annotationMirror, name).map(type::cast).orElse(defaultValue);
    }

    private Optional<Object> findValue(AnnotationMirror mirror, String name) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(name)) continue;
            return Optional.of(entry.getValue().getValue());
        }
        return Optional.empty();
    }

    private BuilderTypeInfo findBuilder(TypeElement classElement) {
        BuilderTypeInfo found;
        List<? extends TypeMirror> interfaces = classElement.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (!(typeMirror instanceof DeclaredType)) continue;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            if (!this.typeUtils.isSameType(this.typeUtils.erasure(this.builderType), this.typeUtils.erasure(declaredType))) continue;
            TypeMirror builtType = declaredType.getTypeArguments().get(1);
            return new BuilderTypeInfo(this.typeUtils.erasure(builtType).toString());
        }
        for (TypeMirror typeMirror : interfaces) {
            DeclaredType type;
            Element element;
            if (!(typeMirror instanceof DeclaredType) || !((element = (type = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
            found = this.findBuilder((TypeElement)element);
            if (!found.isBuilder) continue;
            return found;
        }
        TypeMirror typeMirror = classElement.getSuperclass();
        String string = this.findBuildMethodTarget(classElement);
        if (typeMirror.getKind() != TypeKind.NONE) {
            TypeElement superclass = (TypeElement)this.typeUtils.asElement(this.typeUtils.erasure(typeMirror));
            found = this.findBuilder(superclass);
            if (found.isBuilder) {
                if (string == null) {
                    return found;
                }
                return new BuilderTypeInfo(string);
            }
        }
        return new BuilderTypeInfo();
    }

    private void addInterfaces(ConfiguredType type, TypeElement classElement) {
        List<? extends TypeMirror> interfaces = classElement.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            TypeElement interfaceElement = (TypeElement)this.typeUtils.asElement(this.typeUtils.erasure(typeMirror));
            if (this.findAnnotation(interfaceElement, CONFIGURED_CLASS).isPresent()) {
                type.addInherited(interfaceElement.toString());
                continue;
            }
            this.addSuperClasses(type, interfaceElement);
        }
    }

    private void addSuperClasses(ConfiguredType type, TypeElement classElement) {
        TypeMirror superMirror = classElement.getSuperclass();
        if (superMirror.getKind() == TypeKind.NONE) {
            return;
        }
        TypeElement superclass = (TypeElement)this.typeUtils.asElement(this.typeUtils.erasure(superMirror));
        while (true) {
            if (this.findAnnotation(superclass, CONFIGURED_CLASS).isPresent()) {
                type.addInherited(superclass.toString());
                return;
            }
            superMirror = superclass.getSuperclass();
            if (superMirror.getKind() == TypeKind.NONE) {
                return;
            }
            superclass = (TypeElement)this.typeUtils.asElement(superMirror);
        }
    }

    private List<String> toProvides(Element aClass) {
        return this.findAnnotation(aClass, CONFIGURED_CLASS).map(mirror -> this.findValue((AnnotationMirror)mirror, "provides", (Class)List.class, (Object)List.of())).map(values -> values.stream().map(AnnotationValue::getValue).map(Object::toString).collect(Collectors.toList())).orElseGet(List::of);
    }

    private void processBuilderType(TypeElement builderElement, ConfiguredType type, String className, String targetClass) {
        type.addProducer(new ConfiguredType.ProducerMethod(false, className, "build", new String[0]));
        if (this.hasCreate(this.elementUtils.getTypeElement(targetClass))) {
            type.addProducer(new ConfiguredType.ProducerMethod(true, targetClass, "create", new String[]{"io.helidon.config.Config"}));
        }
        this.elementUtils.getAllMembers(builderElement).stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> this.isMine(builderElement, (ExecutableElement)it)).filter(it -> it.getModifiers().contains((Object)Modifier.PUBLIC)).filter(it -> !it.getModifiers().contains((Object)Modifier.STATIC)).filter(it -> this.isBuilderMethod(builderElement, (ExecutableElement)it)).forEach(it -> this.processBuilderMethod((ExecutableElement)it, type, className));
    }

    private boolean isMine(TypeElement type, ExecutableElement method) {
        Element enclosingElement = method.getEnclosingElement();
        return type.equals(enclosingElement);
    }

    private boolean isBuilderMethod(TypeElement builderElement, ExecutableElement it) {
        TypeMirror methodReturnType;
        TypeMirror builderType = builderElement.asType();
        if (this.typeUtils.isSameType(builderType, methodReturnType = it.getReturnType())) {
            return true;
        }
        return this.findAnnotation(it, CONFIGURED_OPTION_CLASS).isPresent();
    }

    private void processTargetType(TypeElement typeElement, ConfiguredType type, String className, boolean standalone) {
        List methods = this.elementUtils.getAllMembers(typeElement).stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> it.getModifiers().contains((Object)Modifier.PUBLIC)).filter(it -> it.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
        boolean isTargetType = false;
        LinkedList<ExecutableElement> validMethods = new LinkedList<ExecutableElement>();
        ExecutableElement configCreator = null;
        for (ExecutableElement method : methods) {
            Name simpleName = method.getSimpleName();
            if (simpleName.contentEquals("create")) {
                if (!this.typeUtils.isSameType(typeElement.asType(), method.getReturnType())) continue;
                validMethods.add(method);
                List<? extends VariableElement> parameters = method.getParameters();
                if (parameters.size() == 1 && this.typeUtils.isSameType(parameters.get(0).asType(), this.configType)) {
                    configCreator = method;
                }
                isTargetType = true;
                continue;
            }
            if (!simpleName.contentEquals("builder")) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Type " + className + " is marked with @Configured, yet it has a static builder() method. Please mark the builder instead of this class.");
        }
        if (isTargetType) {
            if (configCreator != null) {
                type.addProducer(new ConfiguredType.ProducerMethod(true, className, configCreator.getSimpleName().toString(), this.methodParams(configCreator)));
            }
            for (ExecutableElement validMethod : validMethods) {
                List<AnnotationMirror> options = this.findConfiguredOptionAnnotations(validMethod);
                if (options.isEmpty()) continue;
                for (AnnotationMirror option : options) {
                    ConfiguredOptionData data = ConfiguredOptionData.create(this.elementUtils, this.typeUtils, option);
                    if ((data.name == null || data.name.isBlank()) && !data.merge) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "ConfiguredOption on " + typeElement + "." + validMethod + " does not have value defined. It is mandatory on non-builder methods", typeElement);
                        return;
                    }
                    if (data.description == null || data.description.isBlank()) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "ConfiguredOption on " + typeElement + "." + validMethod + " does not have description defined. It is mandatory on non-builder methods", typeElement, option);
                        return;
                    }
                    if (data.type == null) {
                        data.type = "java.lang.String";
                    }
                    ConfiguredType.ConfiguredProperty prop = new ConfiguredType.ConfiguredProperty(null, data.name, data.description, data.defaultValue, data.type, data.experimental, !data.required, data.kind, data.provider, data.deprecated, data.merge, data.allowedValues);
                    type.addProperty(prop);
                }
            }
        } else {
            if (standalone) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Type " + className + " is marked as standalone configuration unit, yet it does have neither a builder method, nor a create method");
                return;
            }
            this.elementUtils.getAllMembers(typeElement).stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> this.isMine(typeElement, (ExecutableElement)it)).filter(it -> it.getModifiers().contains((Object)Modifier.PUBLIC)).filter(it -> !it.getModifiers().contains((Object)Modifier.STATIC)).forEach(it -> this.processBuilderMethod((ExecutableElement)it, type, className));
        }
    }

    private String findBuildMethodTarget(TypeElement typeElement) {
        return this.elementUtils.getAllMembers(typeElement).stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> it.getModifiers().contains((Object)Modifier.PUBLIC)).filter(it -> !it.getModifiers().contains((Object)Modifier.STATIC)).filter(it -> it.getSimpleName().contentEquals("build")).filter(it -> it.getParameters().isEmpty()).filter(it -> it.getReturnType().getKind() != TypeKind.VOID).findFirst().map(it -> it.getReturnType().toString()).orElse(null);
    }

    private boolean hasCreate(TypeElement typeElement) {
        return this.elementUtils.getAllMembers(typeElement).stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> it.getModifiers().contains((Object)Modifier.PUBLIC)).filter(it -> it.getModifiers().contains((Object)Modifier.STATIC)).filter(it -> this.typeUtils.isSameType(typeElement.asType(), it.getReturnType())).filter(it -> it.getSimpleName().contentEquals("create")).anyMatch(it -> {
            List<? extends VariableElement> parameters = it.getParameters();
            if (parameters.size() == 1) {
                VariableElement parameter = parameters.iterator().next();
                return this.typeUtils.isSameType(this.configType, parameter.asType());
            }
            return false;
        });
    }

    private void processBuilderMethod(ExecutableElement element, ConfiguredType configuredType, String className) {
        List<AnnotationMirror> options = this.findConfiguredOptionAnnotations(element);
        if (options.isEmpty()) {
            return;
        }
        for (AnnotationMirror option : options) {
            ConfiguredOptionData data = ConfiguredOptionData.create(this.elementUtils, this.typeUtils, option);
            String name = this.key(data.name, element);
            String description = this.description(data.description, element);
            String defaultValue = this.defaultValue(data.defaultValue);
            boolean experimental = data.experimental;
            OptionType type = this.type(data, element);
            boolean optional = defaultValue != null || !data.required;
            boolean deprecated = data.deprecated;
            List<AllowedValue> allowedValues = this.allowedValues(data, type.elementType);
            String[] paramTypes = this.methodParams(element);
            ConfiguredType.ProducerMethod builderMethod = new ConfiguredType.ProducerMethod(false, className, element.getSimpleName().toString(), paramTypes);
            ConfiguredType.ConfiguredProperty property = new ConfiguredType.ConfiguredProperty(builderMethod.toString(), name, description, defaultValue, type.elementType, experimental, optional, type.kind, data.provider, deprecated, data.merge, allowedValues);
            configuredType.addProperty(property);
        }
    }

    private String[] methodParams(ExecutableElement element) {
        return (String[])element.getParameters().stream().map(it -> it.asType().toString()).toArray(String[]::new);
    }

    private String description(String description, Element element) {
        if (description == null || description.isBlank()) {
            return ConfigMetadataHandler.javadoc(this.elementUtils.getDocComment(element));
        }
        return description;
    }

    private String defaultValue(String defaultValue) {
        return UNCONFIGURED_OPTION.equals(defaultValue) ? null : defaultValue;
    }

    private OptionType type(ConfiguredOptionData annotation, ExecutableElement element) {
        if (annotation.type == null || annotation.type.equals(CONFIGURED_OPTION_CLASS)) {
            List<? extends VariableElement> parameters = element.getParameters();
            if (parameters.size() != 1) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Method " + element + " is annotated with @Configured, yet it does not have explicit type, or exactly one parameter", element);
                throw new IllegalStateException("Could not determine property type");
            }
            VariableElement parameter = parameters.iterator().next();
            TypeMirror paramType = parameter.asType();
            TypeMirror erasedType = this.typeUtils.erasure(paramType);
            if (this.typeUtils.isSameType(erasedType, this.erasedListType) || this.typeUtils.isSameType(erasedType, this.erasedSetType) || this.typeUtils.isSameType(erasedType, this.erasedIterableType)) {
                DeclaredType type = (DeclaredType)paramType;
                TypeMirror genericType = type.getTypeArguments().get(0);
                return new OptionType(genericType.toString(), "LIST");
            }
            if (this.typeUtils.isSameType(erasedType, this.erasedMapType)) {
                DeclaredType type = (DeclaredType)paramType;
                TypeMirror genericType = type.getTypeArguments().get(1);
                return new OptionType(genericType.toString(), "MAP");
            }
            String typeName = paramType instanceof PrimitiveType ? this.typeUtils.boxedClass((PrimitiveType)paramType).toString() : paramType.toString();
            return new OptionType(typeName, annotation.kind);
        }
        return new OptionType(annotation.type, annotation.kind);
    }

    private String key(String annotationValue, Element element) {
        if (annotationValue == null || annotationValue.isBlank()) {
            Name simpleName = element.getSimpleName();
            String methodName = simpleName.toString();
            return this.toConfigKey(methodName);
        }
        return annotationValue;
    }

    private static String javadoc(String docComment) {
        if (null == docComment) {
            return "";
        }
        String javadoc = docComment;
        int index = javadoc.indexOf("@param");
        if (index > -1) {
            javadoc = docComment.substring(0, index);
        }
        javadoc = JAVADOC_CODE.matcher(javadoc).replaceAll(it -> "`" + it.group(1) + "`");
        javadoc = JAVADOC_LINK.matcher(javadoc).replaceAll(it -> it.group(1));
        return javadoc.trim();
    }

    private void storeMetadata() {
        try (PrintWriter metaWriter = new PrintWriter(this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", META_FILE, new Element[0]).openWriter());){
            JArray moduleArray = new JArray();
            for (Map.Entry<String, List<String>> module : this.moduleTypes.entrySet()) {
                String moduleName = module.getKey();
                List<String> types = module.getValue();
                JArray typeArray = new JArray();
                types.forEach(it -> this.newOptions.get(it).write(typeArray));
                moduleArray.add(new JObject().add("module", moduleName).add("types", typeArray));
            }
            moduleArray.write(metaWriter);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write configuration metadata: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String toMessage(Exception e) {
        return e.getClass().getName() + ": " + e.getMessage();
    }

    List<AnnotationMirror> findConfiguredOptionAnnotations(ExecutableElement element) {
        Optional<AnnotationMirror> annotation = this.findAnnotation(element, CONFIGURED_OPTIONS_CLASS);
        if (annotation.isPresent()) {
            return this.findValue(annotation.get(), "value", List.class, List.of());
        }
        annotation = this.findAnnotation(element, CONFIGURED_OPTION_CLASS);
        return annotation.map(List::of).orElseGet(List::of);
    }

    String toConfigKey(String methodName) {
        char[] chars;
        StringBuilder result = new StringBuilder(methodName.length() + 5);
        for (char aChar : chars = methodName.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.length() == 0) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }

    static List<AllowedValue> allowedValues(Elements elementUtils, TypeElement typeElement) {
        if (typeElement != null && typeElement.getKind() == ElementKind.ENUM) {
            return typeElement.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(element -> new AllowedValue(element.toString(), ConfigMetadataHandler.javadoc(elementUtils.getDocComment((Element)element)))).collect(Collectors.toList());
        }
        return List.of();
    }

    private List<AllowedValue> allowedValues(ConfiguredOptionData annotation, String type) {
        if (type.equals(annotation.type) || !annotation.allowedValues.isEmpty()) {
            return annotation.allowedValues;
        }
        return ConfigMetadataHandler.allowedValues(this.elementUtils, this.elementUtils.getTypeElement(type));
    }

    private static class BuilderTypeInfo {
        private final boolean isBuilder;
        private final String targetClass;

        BuilderTypeInfo() {
            this.isBuilder = false;
            this.targetClass = null;
        }

        BuilderTypeInfo(String targetClass) {
            this.isBuilder = true;
            this.targetClass = targetClass;
        }
    }

    private static final class ConfiguredOptionData {
        private final List<AllowedValue> allowedValues = new LinkedList<AllowedValue>();
        private String name;
        private String type;
        private String description;
        private boolean required;
        private String defaultValue;
        private boolean experimental;
        private boolean provider;
        private boolean deprecated;
        private boolean merge;
        private String kind = "VALUE";

        private ConfiguredOptionData() {
        }

        static ConfiguredOptionData create(Elements elementUtils, Types typeUtils, AnnotationMirror configuredMirror) {
            ConfiguredOptionData result = new ConfiguredOptionData();
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = configuredMirror.getElementValues();
            TypeElement enumType = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                Name key = entry.getKey().getSimpleName();
                Object value = entry.getValue().getValue();
                if (key.contentEquals("key")) {
                    result.name = (String)value;
                    continue;
                }
                if (key.contentEquals("description")) {
                    result.description = (String)value;
                    continue;
                }
                if (key.contentEquals("value")) {
                    result.defaultValue = (String)value;
                    continue;
                }
                if (key.contentEquals("experimental")) {
                    result.experimental = (Boolean)value;
                    continue;
                }
                if (key.contentEquals("required")) {
                    result.required = (Boolean)value;
                    continue;
                }
                if (key.contentEquals("mergeWithParent")) {
                    result.merge = (Boolean)value;
                    continue;
                }
                if (key.contentEquals("type")) {
                    TypeMirror typeMirror = (TypeMirror)value;
                    Element element = typeUtils.asElement(typeMirror);
                    if (element.getKind() == ElementKind.ENUM) {
                        enumType = (TypeElement)element;
                    }
                    result.type = value.toString();
                    continue;
                }
                if (key.contentEquals("kind")) {
                    result.kind = value.toString();
                    continue;
                }
                if (key.contentEquals("provider")) {
                    result.provider = (Boolean)value;
                    continue;
                }
                if (key.contentEquals("deprecated")) {
                    result.deprecated = (Boolean)value;
                    continue;
                }
                if (!key.contentEquals("allowedValues")) continue;
                ((List)value).stream().map(AllowedValue::create).forEach(result.allowedValues::add);
            }
            if (result.allowedValues.isEmpty() && enumType != null) {
                result.allowedValues.addAll(ConfigMetadataHandler.allowedValues(elementUtils, enumType));
            }
            return result;
        }
    }

    private static final class OptionType {
        private final String elementType;
        private final String kind;

        private OptionType(String elementType, String kind) {
            this.elementType = elementType;
            this.kind = kind;
        }
    }

    static final class AllowedValue {
        private String value;
        private String description;

        AllowedValue() {
        }

        AllowedValue(String value, String description) {
            this.value = value;
            this.description = description;
        }

        private static AllowedValue create(AnnotationMirror annotationMirror) {
            AllowedValue result = new AllowedValue();
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                Name key = entry.getKey().getSimpleName();
                Object value = entry.getValue().getValue();
                if (key.contentEquals("value")) {
                    result.value = (String)value;
                    continue;
                }
                if (!key.contentEquals("description")) continue;
                result.description = (String)value;
            }
            return result;
        }

        String value() {
            return this.value;
        }

        String description() {
            return this.description;
        }
    }
}

