/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.config.metadata.processor.JArray;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

class JObject {
    private final Map<String, String> stringValues = new TreeMap<String, String>();
    private final Map<String, Boolean> booleanValues = new TreeMap<String, Boolean>();
    private final Map<String, List<String>> stringListValues = new TreeMap<String, List<String>>();
    private final Map<String, JArray> arrayValues = new TreeMap<String, JArray>();

    JObject() {
    }

    JObject add(String key, String value) {
        this.stringValues.put(key, value);
        return this;
    }

    JObject add(String key, boolean value) {
        this.booleanValues.put(key, value);
        return this;
    }

    JObject add(String key, JArray array) {
        this.arrayValues.put(key, array);
        return this;
    }

    JObject add(String key, List<String> values) {
        this.stringListValues.put(key, values);
        return this;
    }

    void write(PrintWriter metaWriter) {
        metaWriter.write(123);
        AtomicBoolean first = new AtomicBoolean(true);
        this.stringValues.forEach((key, value) -> {
            this.writeNext(metaWriter, first);
            metaWriter.write(34);
            metaWriter.write((String)key);
            metaWriter.write("\":\"");
            metaWriter.write(this.escape((String)value));
            metaWriter.write(34);
        });
        this.booleanValues.forEach((key, value) -> {
            this.writeNext(metaWriter, first);
            metaWriter.write(34);
            metaWriter.write((String)key);
            metaWriter.write("\":");
            metaWriter.write(String.valueOf(value));
        });
        this.stringListValues.forEach((key, value) -> {
            this.writeNext(metaWriter, first);
            metaWriter.write(34);
            metaWriter.write((String)key);
            metaWriter.write("\":[");
            this.writeStringList(metaWriter, (List<String>)value);
            metaWriter.write(93);
        });
        this.arrayValues.forEach((key, value) -> {
            this.writeNext(metaWriter, first);
            metaWriter.write(34);
            metaWriter.write((String)key);
            metaWriter.write("\":");
            value.write(metaWriter);
        });
        metaWriter.write(125);
    }

    private void writeStringList(PrintWriter metaWriter, List<String> value) {
        metaWriter.write(value.stream().map(this::escape).map(this::quote).collect(Collectors.joining(",")));
    }

    private String quote(String value) {
        return "\"" + value + "\"";
    }

    private String escape(String string) {
        return string.replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\"");
    }

    private void writeNext(PrintWriter metaWriter, AtomicBoolean first) {
        if (first.get()) {
            first.set(false);
            return;
        }
        metaWriter.write(44);
    }
}

