/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.config.metadata.processor.ConfigMetadataHandler;
import io.helidon.config.metadata.processor.JArray;
import io.helidon.config.metadata.processor.JObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class ConfiguredType {
    private final Set<ConfiguredProperty> allProperties = new HashSet<ConfiguredProperty>();
    private final List<ProducerMethod> producerMethods = new LinkedList<ProducerMethod>();
    private final String targetClass;
    private final boolean standalone;
    private final String prefix;
    private final String description;
    private final List<String> provides;
    private final List<String> inherited = new LinkedList<String>();

    ConfiguredType(String targetClass, boolean standalone, String prefix, String description, List<String> provides) {
        this.targetClass = targetClass;
        this.standalone = standalone;
        this.prefix = prefix;
        this.provides = provides;
        this.description = description;
    }

    private static String paramsToString(String[] params) {
        String result = Arrays.toString(params);
        if (result.startsWith("[") && result.endsWith("]")) {
            return result.substring(1, result.length() - 1);
        }
        return result;
    }

    ConfiguredType addProducer(ProducerMethod producer) {
        this.producerMethods.add(producer);
        return this;
    }

    ConfiguredType addProperty(ConfiguredProperty property) {
        this.allProperties.add(property);
        return this;
    }

    List<ProducerMethod> producers() {
        return this.producerMethods;
    }

    Set<ConfiguredProperty> properties() {
        return this.allProperties;
    }

    String targetClass() {
        return this.targetClass;
    }

    boolean standalone() {
        return this.standalone;
    }

    String prefix() {
        return this.prefix;
    }

    public void write(JArray typeArray) {
        JObject typeObject = new JObject();
        typeObject.add("type", this.targetClass());
        if (this.standalone()) {
            typeObject.add("standalone", true);
        }
        if (this.prefix() != null && !this.prefix.isBlank()) {
            typeObject.add("prefix", this.prefix());
        }
        if (this.description != null && !this.description.isBlank()) {
            typeObject.add("description", this.description);
        }
        if (!this.inherited.isEmpty()) {
            typeObject.add("inherits", this.inherited);
        }
        if (!this.provides.isEmpty()) {
            typeObject.add("provides", this.provides);
        }
        if (!this.producerMethods.isEmpty()) {
            typeObject.add("producers", this.producerMethods.stream().map(Object::toString).collect(Collectors.toList()));
        }
        JArray options = new JArray();
        for (ConfiguredProperty property : this.allProperties) {
            this.writeProperty(options, "", property);
        }
        typeObject.add("options", options);
        typeArray.add(typeObject);
    }

    private void writeProperty(JArray optionsBuilder, String prefix, ConfiguredProperty property) {
        String method;
        JObject optionBuilder = new JObject();
        if (property.key() != null && !property.key.isBlank()) {
            optionBuilder.add("key", this.prefix(prefix, property.key()));
        }
        if (!"java.lang.String".equals(property.type)) {
            optionBuilder.add("type", property.type());
        }
        optionBuilder.add("description", property.description());
        if (property.defaultValue() != null) {
            optionBuilder.add("defaultValue", property.defaultValue());
        }
        if (property.experimental) {
            optionBuilder.add("experimental", true);
        }
        if (!property.optional) {
            optionBuilder.add("required", true);
        }
        if (!property.kind().equals("VALUE")) {
            optionBuilder.add("kind", property.kind());
        }
        if (property.provider) {
            optionBuilder.add("provider", true);
        }
        if (property.deprecated()) {
            optionBuilder.add("deprecated", true);
        }
        if (property.merge()) {
            optionBuilder.add("merge", true);
        }
        if ((method = property.builderMethod()) != null) {
            optionBuilder.add("method", method);
        }
        if (property.configuredType != null) {
            String finalPrefix = property.kind().equals("LIST") ? this.prefix(this.prefix(prefix, property.key()), "*") : this.prefix(prefix, property.key());
            property.configuredType.properties().forEach(it -> this.writeProperty(optionsBuilder, finalPrefix, (ConfiguredProperty)it));
        }
        if (!property.allowedValues.isEmpty()) {
            JArray allowedValues = new JArray();
            for (ConfigMetadataHandler.AllowedValue allowedValue : property.allowedValues) {
                allowedValues.add(new JObject().add("value", allowedValue.value()).add("description", allowedValue.description()));
            }
            optionBuilder.add("allowedValues", allowedValues);
        }
        optionsBuilder.add(optionBuilder);
    }

    private String prefix(String currentPrefix, String newSuffix) {
        if (currentPrefix.isEmpty()) {
            return newSuffix;
        }
        return currentPrefix + "." + newSuffix;
    }

    public String toString() {
        return this.targetClass;
    }

    void addInherited(String classOrIface) {
        this.inherited.add(classOrIface);
    }

    static final class ConfiguredProperty {
        private final String builderMethod;
        private final String key;
        private final String description;
        private final String defaultValue;
        private final String type;
        private final boolean experimental;
        private final boolean optional;
        private final String kind;
        private final boolean provider;
        private final boolean deprecated;
        private final boolean merge;
        private final List<ConfigMetadataHandler.AllowedValue> allowedValues;
        private ConfiguredType configuredType;

        ConfiguredProperty(String builderMethod, String key, String description, String defaultValue, String type, boolean experimental, boolean optional, String kind, boolean provider, boolean deprecated, boolean merge, List<ConfigMetadataHandler.AllowedValue> allowedValues) {
            this.builderMethod = builderMethod;
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.experimental = experimental;
            this.optional = optional;
            this.kind = kind;
            this.provider = provider;
            this.deprecated = deprecated;
            this.merge = merge;
            this.allowedValues = allowedValues;
        }

        String builderMethod() {
            return this.builderMethod;
        }

        String key() {
            return this.key;
        }

        String description() {
            return this.description;
        }

        String defaultValue() {
            return this.defaultValue;
        }

        String type() {
            return this.type;
        }

        boolean experimental() {
            return this.experimental;
        }

        boolean optional() {
            return this.optional;
        }

        String kind() {
            return this.kind;
        }

        boolean deprecated() {
            return this.deprecated;
        }

        boolean merge() {
            return this.merge;
        }

        void nestedType(ConfiguredType nested) {
            this.configuredType = nested;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfiguredProperty that = (ConfiguredProperty)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return this.key;
        }
    }

    static final class ProducerMethod {
        private final boolean isStatic;
        private final String owningClass;
        private final String methodName;
        private final String[] methodParams;

        ProducerMethod(boolean isStatic, String owningClass, String methodName, String[] methodParams) {
            this.isStatic = isStatic;
            this.owningClass = owningClass;
            this.methodName = methodName;
            this.methodParams = methodParams;
        }

        public String toString() {
            return this.owningClass + "#" + this.methodName + "(" + ConfiguredType.paramsToString(this.methodParams) + ")";
        }
    }
}

