/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.git;

import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.AbstractConfigSource;
import io.helidon.config.AbstractConfigSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.FileSourceHelper;
import io.helidon.config.git.GitConfigSourceBuilder;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ParsableSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitConfigSource
extends AbstractConfigSource
implements ParsableSource,
PollableSource<byte[]>,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(GitConfigSource.class.getName());
    private final URI uri;
    private final String branch;
    private Path directory;
    private Path targetPath;
    private Repository repository;
    private GitConfigSourceBuilder.GitEndpoint endpoint;
    private boolean isTempDirectory = false;
    private boolean isClosed = false;
    private final List<Git> gits = Collections.synchronizedList(new ArrayList());

    GitConfigSource(GitConfigSourceBuilder builder, GitConfigSourceBuilder.GitEndpoint endpoint) {
        super((AbstractConfigSourceBuilder)builder);
        this.endpoint = endpoint;
        this.uri = endpoint.uri();
        this.branch = endpoint.branch();
        if (endpoint.directory() == null) {
            if (this.uri == null) {
                throw new ConfigException("Directory or Uri must be set.");
            }
            try {
                this.directory = Files.createTempDirectory("helidon-config-git-source-", new FileAttribute[0]);
                this.isTempDirectory = true;
            }
            catch (IOException e) {
                throw new ConfigException("Cannot create temporary directory.", (Throwable)e);
            }
        } else {
            this.directory = endpoint.directory();
        }
    }

    public void init(ConfigContext context) {
        try {
            this.init();
            this.targetPath = this.directory.resolve(this.endpoint.path());
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            throw new ConfigException(String.format("Cannot initialize repository '%s' in local temp dir %s", this.uri.toASCIIString(), this.directory.toString()), e);
        }
    }

    public static GitConfigSource create(Config metaConfig) {
        return GitConfigSource.builder().config(metaConfig).build();
    }

    public static GitConfigSourceBuilder builder() {
        return new GitConfigSourceBuilder();
    }

    protected String uid() {
        StringBuilder sb = new StringBuilder();
        if (this.endpoint.directory() != null) {
            sb.append(this.endpoint.directory());
        }
        if (this.endpoint.uri() != null && this.endpoint.directory() != null) {
            sb.append('|');
        }
        if (this.endpoint.uri() != null) {
            sb.append(this.endpoint.uri().toASCIIString());
        }
        sb.append('#');
        sb.append(this.endpoint.path());
        return sb.toString();
    }

    public Optional<ConfigParser> parser() {
        return super.parser();
    }

    public Optional<PollingStrategy> pollingStrategy() {
        return super.pollingStrategy();
    }

    public boolean isModified(byte[] stamp) {
        try {
            this.pull();
        }
        catch (GitAPIException e) {
            LOGGER.log(Level.WARNING, "Pull failed.", e);
        }
        return FileSourceHelper.isModified((Path)this.targetPath, (byte[])stamp);
    }

    public Optional<ConfigParser.Content> load() throws ConfigException {
        if (!Files.exists(this.targetPath, new LinkOption[0])) {
            return Optional.empty();
        }
        return FileSourceHelper.readDataAndDigest((Path)this.targetPath).map(dad -> ((ConfigParser.Content.Builder)ConfigParser.Content.builder().data((InputStream)new ByteArrayInputStream(dad.data())).stamp((Object)dad.digest())).mediaType(MediaTypes.detectType((Path)this.targetPath)).build());
    }

    public Optional<String> mediaType() {
        return super.mediaType();
    }

    private void init() throws IOException, GitAPIException {
        block13: {
            if (!Files.exists(this.directory, new LinkOption[0])) {
                throw new ConfigException(String.format("Directory '%s' does not exist.", this.directory.toString()));
            }
            if (!Files.isDirectory(this.directory, new LinkOption[0])) {
                throw new ConfigException(String.format("'%s' is not a directory.", this.directory.toString()));
            }
            if (!Files.isReadable(this.directory) || !Files.isWritable(this.directory)) {
                throw new ConfigException(String.format("Directory '%s' is not accessible.", this.directory.toString()));
            }
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.directory);){
                if (dirStream.iterator().hasNext()) {
                    try {
                        this.recordGit(Git.open((File)this.directory.toFile()));
                        break block13;
                    }
                    catch (IOException e) {
                        throw new ConfigException(String.format("Directory '%s' is not empty and it is not a valid repository.", this.directory.toString()));
                    }
                }
                if (this.uri != null) {
                    CloneCommand cloneCommand = ((CloneCommand)Git.cloneRepository().setCredentialsProvider(this.endpoint.credentialsProvider())).setURI(this.uri.toASCIIString()).setBranchesToClone(Collections.singleton("refs/heads/" + this.branch)).setBranch("refs/heads/" + this.branch).setDirectory(this.directory.toFile());
                    Git cloneResult = this.recordGit(cloneCommand.call());
                    LOGGER.log(Level.CONFIG, () -> String.format("git clone result: %s", cloneResult.toString()));
                }
            }
        }
        this.repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.directory.resolve(".git").toFile())).build();
        this.pull();
    }

    private void pull() throws GitAPIException {
        Git git = this.recordGit(Git.wrap((Repository)this.repository));
        PullCommand pull = ((PullCommand)git.pull().setCredentialsProvider(this.endpoint.credentialsProvider())).setRebase(true);
        PullResult result = pull.call();
        if (!result.isSuccessful()) {
            LOGGER.log(Level.WARNING, () -> String.format("Cannot pull from git '%s', branch '%s'", this.uri.toASCIIString(), this.branch));
            if (LOGGER.isLoggable(Level.FINEST)) {
                Status status = git.status().call();
                LOGGER.finest(() -> "git status cleanliness: " + status.isClean());
                if (!status.isClean()) {
                    LOGGER.finest(() -> "git status uncommitted changes: " + status.getUncommittedChanges());
                    LOGGER.finest(() -> "git status untracked: " + status.getUntracked());
                }
            }
        } else {
            LOGGER.fine("Pull was successful.");
        }
        LOGGER.finest(() -> "git rebase result: " + result.getRebaseResult().getStatus().name());
        LOGGER.finest(() -> "git fetch result: " + result.getFetchResult().getMessages());
    }

    GitConfigSourceBuilder.GitEndpoint gitEndpoint() {
        return this.endpoint;
    }

    private Git recordGit(Git git) {
        this.gits.add(git);
        return git;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            try {
                if (this.repository != null) {
                    this.repository.close();
                }
                this.closeGits();
                if (this.isTempDirectory) {
                    this.deleteTempDirectory();
                }
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    private void closeGits() {
        this.gits.forEach(Git::close);
    }

    private void deleteTempDirectory() throws IOException {
        LOGGER.log(Level.FINE, () -> String.format("GitConfigSource deleting temp directory %s", this.directory.toString()));
        Files.walkFileTree(this.directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isWritable(file)) {
                    file.toFile().setWritable(true);
                }
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

