/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.junit5;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TemporaryFolderExt
implements BeforeEachCallback,
AfterEachCallback {
    private Path root;

    private TemporaryFolderExt() {
    }

    public static TemporaryFolderExt build() {
        return new TemporaryFolderExt();
    }

    public File newFolder() throws IOException {
        Path tempPath = Files.createTempDirectory(this.root, "test", new FileAttribute[0]);
        return tempPath.toFile();
    }

    public File newFolder(String name) throws IOException {
        int nameStart = name.startsWith("/") ? 1 : 0;
        return Files.createDirectory(this.root.resolve(name.substring(nameStart)), new FileAttribute[0]).toFile();
    }

    public File newFile() throws IOException {
        return Files.createTempFile(this.root, "test", "file", new FileAttribute[0]).toFile();
    }

    public File newFile(String name) throws IOException {
        int nameStart = name.startsWith("/") ? 1 : 0;
        return Files.createFile(this.root.resolve(name.substring(nameStart)), new FileAttribute[0]).toFile();
    }

    public File getRoot() {
        return this.root.toFile();
    }

    public void beforeEach(ExtensionContext ec) throws Exception {
        this.root = Files.createTempDirectory("test", new FileAttribute[0]);
    }

    public void afterEach(ExtensionContext ec) throws Exception {
        TemporaryFolderExt.deleteDir(this.root);
    }

    private static void deleteDir(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (!Files.isWritable(path)) {
                    path.toFile().setWritable(true);
                }
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

