/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.junit5;

import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RestoreSystemPropertiesExt
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String SYSPROPS_KEY = "systemProps";

    public void beforeTestExecution(ExtensionContext ec) throws Exception {
        this.getStore(ec).put((Object)SYSPROPS_KEY, (Object)System.getProperties());
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)System.getProperties());
        System.setProperties(copy);
    }

    public void afterTestExecution(ExtensionContext ec) throws Exception {
        System.setProperties(this.getSavedProps(ec));
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestMethod()}));
    }

    private Properties getSavedProps(ExtensionContext ec) throws Exception {
        Object o = this.getStore(ec).get((Object)SYSPROPS_KEY);
        return (Properties)Properties.class.cast(o);
    }
}

