/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor;

import io.helidon.common.processor.AnnotationFactory;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

class ToAnnotationValueVisitor
implements AnnotationValueVisitor<Object, Object> {
    private final Elements elements;
    private boolean mapVoidToNull;
    private boolean mapFalseToNull;
    private boolean mapEmptyStringToNull;
    private boolean mapBlankArrayToNull;
    private boolean mapToSourceDeclaration;

    ToAnnotationValueVisitor(Elements elements) {
        this.elements = elements;
    }

    ToAnnotationValueVisitor mapVoidToNull(boolean val) {
        this.mapVoidToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapBooleanToNull(boolean val) {
        this.mapFalseToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapEmptyStringToNull(boolean val) {
        this.mapEmptyStringToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapBlankArrayToNull(boolean val) {
        this.mapBlankArrayToNull = val;
        return this;
    }

    ToAnnotationValueVisitor mapToSourceDeclaration(boolean val) {
        this.mapToSourceDeclaration = val;
        return this;
    }

    @Override
    public Object visit(AnnotationValue av, Object o) {
        return av.accept(this, o);
    }

    @Override
    public Object visitBoolean(boolean b, Object o) {
        if (!b && this.mapFalseToNull) {
            return null;
        }
        return b;
    }

    @Override
    public Object visitByte(byte b, Object o) {
        return b;
    }

    @Override
    public Object visitChar(char c, Object o) {
        return Character.valueOf(c);
    }

    @Override
    public Object visitDouble(double d, Object o) {
        return d;
    }

    @Override
    public Object visitFloat(float f, Object o) {
        return Float.valueOf(f);
    }

    @Override
    public Object visitInt(int i, Object o) {
        return i;
    }

    @Override
    public Object visitLong(long i, Object o) {
        return i;
    }

    @Override
    public Object visitShort(short s, Object o) {
        return s;
    }

    @Override
    public Object visitString(String s, Object o) {
        if (this.mapEmptyStringToNull && s != null && s.isBlank()) {
            return null;
        }
        if (this.mapToSourceDeclaration) {
            return "\"" + s + "\"";
        }
        return s;
    }

    @Override
    public Object visitType(TypeMirror t, Object o) {
        String val = t.toString();
        if (this.mapVoidToNull && ("void".equals(val) || Void.class.getName().equals(val))) {
            val = null;
        }
        return val;
    }

    @Override
    public Object visitEnumConstant(VariableElement c, Object o) {
        return String.valueOf(c.getSimpleName());
    }

    @Override
    public Object visitAnnotation(AnnotationMirror a, Object o) {
        return AnnotationFactory.createAnnotation(a, this.elements);
    }

    @Override
    public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
        ArrayList<Object> values = new ArrayList<Object>(vals.size());
        for (AnnotationValue annotationValue : vals) {
            Object object = annotationValue.accept(this, null);
            if (object == null) continue;
            values.add(object);
        }
        if (this.mapBlankArrayToNull && values.isEmpty()) {
            return null;
        }
        if (this.mapToSourceDeclaration) {
            StringBuilder resultBuilder = new StringBuilder("{");
            for (AnnotationValue annotationValue : vals) {
                Object stringVal = annotationValue.accept(this, null);
                if (stringVal == null) continue;
                if (resultBuilder.length() > 1) {
                    resultBuilder.append(", ");
                }
                resultBuilder.append(stringVal);
            }
            resultBuilder.append("}");
            return resultBuilder.toString();
        }
        return values;
    }

    @Override
    public String visitUnknown(AnnotationValue av, Object o) {
        return null;
    }
}

