/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor;

import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.function.Predicate;

public final class ElementInfoPredicates {
    public static boolean isMethod(TypedElementInfo element) {
        return ElementKind.METHOD == element.kind();
    }

    public static boolean isStatic(TypedElementInfo element) {
        return element.elementModifiers().contains(Modifier.STATIC);
    }

    public static boolean isPrivate(TypedElementInfo element) {
        return AccessModifier.PRIVATE == element.accessModifier();
    }

    public static boolean isPublic(TypedElementInfo element) {
        return AccessModifier.PUBLIC == element.accessModifier();
    }

    public static boolean isDefault(TypedElementInfo element) {
        return element.elementModifiers().contains(Modifier.DEFAULT);
    }

    public static boolean isVoid(TypedElementInfo element) {
        TypeName typeName = element.typeName();
        return TypeNames.PRIMITIVE_VOID.equals((Object)typeName) || TypeNames.BOXED_VOID.equals((Object)typeName);
    }

    public static boolean hasNoArgs(TypedElementInfo element) {
        return element.parameterArguments().isEmpty();
    }

    public static Predicate<TypedElementInfo> hasAnnotation(TypeName annotation) {
        return element -> element.hasAnnotation(annotation);
    }

    public static Predicate<TypedElementInfo> elementName(String name) {
        return element -> name.equals(element.elementName());
    }

    public static Predicate<TypedElementInfo> hasParams(TypeName ... paramTypes) {
        return element -> {
            List arguments = element.parameterArguments();
            if (paramTypes.length != arguments.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                TypeName paramType = paramTypes[i];
                if (paramType.equals((Object)((TypedElementInfo)arguments.get(i)).typeName())) continue;
                return false;
            }
            return true;
        };
    }

    private ElementInfoPredicates() {
    }
}

