/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor;

import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.function.Predicate;

public final class ElementInfoPredicates {
    public static boolean isMethod(TypedElementInfo element) {
        return "METHOD".equals(element.elementTypeKind());
    }

    public static boolean isStatic(TypedElementInfo element) {
        return element.modifiers().contains("static");
    }

    public static boolean isPrivate(TypedElementInfo element) {
        return element.modifiers().contains("private");
    }

    public static boolean isPublic(TypedElementInfo element) {
        return element.modifiers().contains("public");
    }

    public static boolean isDefault(TypedElementInfo element) {
        return element.modifiers().contains("default");
    }

    public static boolean isVoid(TypedElementInfo element) {
        TypeName typeName = element.typeName();
        return TypeNames.PRIMITIVE_VOID.equals((Object)typeName) || TypeNames.BOXED_VOID.equals((Object)typeName);
    }

    public static boolean hasNoArgs(TypedElementInfo element) {
        return element.parameterArguments().isEmpty();
    }

    public static Predicate<TypedElementInfo> hasAnnotation(TypeName annotation) {
        return element -> element.hasAnnotation(annotation);
    }

    public static Predicate<TypedElementInfo> elementName(String name) {
        return element -> name.equals(element.elementName());
    }

    public static Predicate<TypedElementInfo> hasParams(TypeName ... paramTypes) {
        return element -> {
            List arguments = element.parameterArguments();
            if (paramTypes.length != arguments.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                TypeName paramType = paramTypes[i];
                if (paramType.equals((Object)((TypedElementInfo)arguments.get(i)).typeName())) continue;
                return false;
            }
            return true;
        };
    }

    private ElementInfoPredicates() {
    }
}

