/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor;

import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class TypeFactory {
    private TypeFactory() {
    }

    public static Optional<TypeName> createTypeName(DeclaredType type) {
        return TypeFactory.createTypeName(type.asElement());
    }

    public static Optional<TypeName> createTypeName(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind.isPrimitive()) {
            Class<Comparable<Boolean>> type = switch (kind) {
                case TypeKind.BOOLEAN -> Boolean.TYPE;
                case TypeKind.BYTE -> Byte.TYPE;
                case TypeKind.SHORT -> Short.TYPE;
                case TypeKind.INT -> Integer.TYPE;
                case TypeKind.LONG -> Long.TYPE;
                case TypeKind.CHAR -> Character.TYPE;
                case TypeKind.FLOAT -> Float.TYPE;
                case TypeKind.DOUBLE -> Double.TYPE;
                default -> throw new IllegalStateException("Unknown primitive type: " + String.valueOf((Object)kind));
            };
            return Optional.of(TypeName.create(type));
        }
        switch (kind) {
            case VOID: {
                return Optional.of(TypeName.create(Void.TYPE));
            }
            case TYPEVAR: {
                return Optional.of(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
            }
            case WILDCARD: 
            case ERROR: {
                return Optional.of(TypeName.create((String)typeMirror.toString()));
            }
            case NONE: {
                return Optional.empty();
            }
        }
        if (typeMirror instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return Optional.of(((TypeName.Builder)TypeName.builder((TypeName)TypeFactory.createTypeName(arrayType.getComponentType()).orElseThrow()).array(true)).build());
        }
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List typeParams = declaredType.getTypeArguments().stream().map(TypeFactory::createTypeName).flatMap(Optional::stream).collect(Collectors.toList());
            TypeName result = TypeFactory.createTypeName(declaredType.asElement()).orElse(null);
            if (typeParams.isEmpty() || result == null) {
                return Optional.ofNullable(result);
            }
            return Optional.of(((TypeName.Builder)TypeName.builder((TypeName)result).typeArguments(typeParams)).build());
        }
        throw new IllegalStateException("Unknown type mirror: " + String.valueOf(typeMirror));
    }

    public static Optional<TypeName> createTypeName(Element type) {
        String packageName;
        Element enclosing;
        if (type instanceof VariableElement) {
            return TypeFactory.createTypeName(type.asType());
        }
        if (type instanceof ExecutableElement) {
            return TypeFactory.createTypeName(((ExecutableElement)type).getReturnType());
        }
        List<String> classNames = new ArrayList<String>();
        String simpleName = type.getSimpleName().toString();
        for (enclosing = type.getEnclosingElement(); enclosing != null && ElementKind.PACKAGE != enclosing.getKind(); enclosing = enclosing.getEnclosingElement()) {
            if (enclosing.getKind() != ElementKind.CLASS && enclosing.getKind() != ElementKind.INTERFACE && enclosing.getKind() != ElementKind.ANNOTATION_TYPE && enclosing.getKind() != ElementKind.RECORD) continue;
            classNames.add(enclosing.getSimpleName().toString());
        }
        Collections.reverse(classNames);
        while (enclosing != null && enclosing.getKind() != ElementKind.PACKAGE) {
            enclosing = enclosing.getEnclosingElement();
        }
        String string = packageName = enclosing == null ? "" : ((PackageElement)enclosing).getQualifiedName().toString();
        if (!packageName.isEmpty() && Character.isUpperCase(packageName.charAt(0))) {
            classNames = List.of(packageName.split("\\."));
            packageName = "";
        }
        return Optional.of(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(packageName)).className(simpleName)).enclosingNames(classNames)).build());
    }

    public static void ensureIsFqn(TypeName name) {
        if (!TypeFactory.isFqn(name)) {
            throw new IllegalStateException("needs to be a fully qualified name: " + String.valueOf(name));
        }
    }

    public static boolean isFqn(TypeName name) {
        return !Objects.requireNonNull(name.packageName()).isBlank() && !Objects.requireNonNull(name.className()).isBlank() && !Objects.requireNonNull(name.name()).isBlank();
    }
}

