/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class ImportSorter {
    private ImportSorter() {
    }

    static List<List<String>> sortImports(Collection<String> imports) {
        if (imports.isEmpty()) {
            return List.of();
        }
        List<String> sorted = imports.stream().sorted().toList();
        ArrayList<String> javaImports = new ArrayList<String>();
        ArrayList<String> javaxImports = new ArrayList<String>();
        ArrayList<String> helidonImports = new ArrayList<String>();
        ArrayList<String> everythingElse = new ArrayList<String>();
        for (String val : sorted) {
            if (val.startsWith("java.")) {
                javaImports.add(val);
                continue;
            }
            if (val.startsWith("javax.")) {
                javaxImports.add(val);
                continue;
            }
            if (val.startsWith("io.helidon.")) {
                helidonImports.add(val);
                continue;
            }
            everythingElse.add(val);
        }
        return List.of(javaImports, javaxImports, helidonImports, everythingElse);
    }
}

