/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.DescribableComponent;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.types.AccessModifier;
import java.util.List;
import java.util.Objects;

abstract class CommonComponent
extends DescribableComponent {
    private final String name;
    private final Javadoc javadoc;
    private final AccessModifier accessModifier;

    CommonComponent(Builder<?, ?> builder) {
        super((DescribableComponent.Builder<?, ?>)builder);
        this.name = builder.name;
        this.accessModifier = builder.accessModifier;
        this.javadoc = builder.javadocBuilder.build(builder);
    }

    String name() {
        return this.name;
    }

    Javadoc javadoc() {
        return this.javadoc;
    }

    AccessModifier accessModifier() {
        return this.accessModifier;
    }

    static abstract class Builder<B extends Builder<B, T>, T extends CommonComponent>
    extends DescribableComponent.Builder<B, T> {
        private final Javadoc.Builder javadocBuilder = Javadoc.builder();
        private AccessModifier accessModifier = AccessModifier.PUBLIC;
        private String name;

        Builder() {
        }

        @Override
        B description(String description) {
            return (B)this.description((List)List.of(description));
        }

        @Override
        B description(List<String> description) {
            this.javadocBuilder.content(description);
            this.javadocBuilder.generate(true);
            return (B)((Builder)this.identity());
        }

        B addDescriptionLine(String line) {
            this.javadocBuilder.addLine(line);
            return (B)((Builder)this.identity());
        }

        B javadoc(Javadoc javadoc) {
            this.javadocBuilder.from(javadoc);
            return (B)((Builder)this.identity());
        }

        B generateJavadoc(boolean generateJavadoc) {
            this.javadocBuilder.generate(generateJavadoc);
            return (B)((Builder)this.identity());
        }

        B addJavadocParameter(String parameter, List<String> description) {
            this.javadocBuilder.addParameter(parameter, description);
            return (B)((Builder)this.identity());
        }

        B addGenericToken(String parameter, String description) {
            this.javadocBuilder.addGenericArgument(parameter, description);
            return (B)((Builder)this.identity());
        }

        B addGenericToken(String parameter, List<String> description) {
            this.javadocBuilder.addGenericArgument(parameter, description);
            return (B)((Builder)this.identity());
        }

        B addJavadocThrows(String exception, List<String> description) {
            this.javadocBuilder.addThrows(exception, description);
            return (B)((Builder)this.identity());
        }

        B addJavadocTag(String tag, String description) {
            this.javadocBuilder.addTag(tag, description);
            return (B)((Builder)this.identity());
        }

        B deprecationJavadoc(String description) {
            this.javadocBuilder.deprecation(description);
            return (B)((Builder)this.identity());
        }

        B returnJavadoc(String description) {
            this.javadocBuilder.returnDescription(description);
            return (B)((Builder)this.identity());
        }

        B returnJavadoc(List<String> description) {
            this.javadocBuilder.returnDescription(description);
            return (B)((Builder)this.identity());
        }

        B name(String name) {
            this.name = Objects.requireNonNull(name);
            return (B)((Builder)this.identity());
        }

        B accessModifier(AccessModifier accessModifier) {
            this.accessModifier = Objects.requireNonNull(accessModifier);
            return (B)((Builder)this.identity());
        }

        String name() {
            return this.name;
        }
    }
}

