/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.AnnotationParameter;
import io.helidon.common.processor.classmodel.ClassModelException;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.CommonComponent;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class Annotation
extends CommonComponent {
    private final List<AnnotationParameter> parameters;

    private Annotation(Builder builder) {
        super(builder);
        this.parameters = List.copyOf(builder.parameters.values());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Annotation create(Class<?> type) {
        return ((Builder)Annotation.builder().type((Class)type)).build();
    }

    public static Annotation parse(String annotationDefinition) {
        int annotationBodyStart = annotationDefinition.indexOf("(");
        int annotationBodyEnd = annotationDefinition.indexOf(")");
        String annotationName = annotationBodyStart > 0 ? annotationDefinition.substring(0, annotationBodyStart) : annotationDefinition;
        Builder builder = Annotation.builder().type(annotationName);
        if (annotationBodyStart > 0) {
            String[] valuePairs;
            for (String valuePair : valuePairs = annotationDefinition.substring(annotationBodyStart + 1, annotationBodyEnd).split(",")) {
                String[] keyValue = valuePair.split("=");
                if (keyValue.length == 1 && valuePairs.length != 1) {
                    throw new IllegalStateException("Invalid custom annotation specified: " + annotationDefinition);
                }
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                builder.addParameter(paramBuilder -> ((AnnotationParameter.Builder)paramBuilder.name(key).type(value.startsWith("\"") ? String.class : Object.class)).value(value));
            }
        }
        return builder.build();
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        writer.write("@" + imports.typeName(this.type(), this.includeImport()));
        if (!this.parameters.isEmpty()) {
            writer.write("(");
            if (this.parameters.size() == 1) {
                AnnotationParameter parameter = this.parameters.get(0);
                if (parameter.name().equals("value")) {
                    writer.write(parameter.value());
                } else {
                    parameter.writeComponent(writer, declaredTokens, imports, classType);
                }
            } else {
                boolean first = true;
                for (AnnotationParameter parameter : this.parameters) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(", ");
                    }
                    parameter.writeComponent(writer, declaredTokens, imports, classType);
                }
            }
            writer.write(")");
        }
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.parameters.forEach(parameter -> parameter.addImports(imports));
    }

    public static final class Builder
    extends CommonComponent.Builder<Builder, Annotation> {
        private final Map<String, AnnotationParameter> parameters = new LinkedHashMap<String, AnnotationParameter>();

        private Builder() {
        }

        public Annotation build() {
            if (this.type() == null) {
                throw new ClassModelException("Annotation type needs to be set");
            }
            return new Annotation(this);
        }

        @Override
        public Builder type(TypeName type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(String type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(Class<?> type) {
            return (Builder)super.type(type);
        }

        public Builder addParameter(String name, Object value) {
            Objects.requireNonNull(value);
            Class paramType = value instanceof TypeName ? Class.class : value.getClass();
            return this.addParameter((AnnotationParameter.Builder builder) -> ((AnnotationParameter.Builder)builder.name(name).type(paramType)).value(value));
        }

        public Builder addParameter(Consumer<AnnotationParameter.Builder> consumer) {
            Objects.requireNonNull(consumer);
            AnnotationParameter.Builder builder = AnnotationParameter.builder();
            consumer.accept(builder);
            return this.addParameter(builder.build());
        }

        public Builder addParameter(AnnotationParameter.Builder builder) {
            Objects.requireNonNull(builder);
            return this.addParameter(builder.build());
        }

        public Builder addParameter(AnnotationParameter parameter) {
            Objects.requireNonNull(parameter);
            this.parameters.put(parameter.name(), parameter);
            return this;
        }
    }
}

