/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.Annotation;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.Executable;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import java.io.IOException;
import java.util.Set;

public final class Constructor
extends Executable {
    private Constructor(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        if (this.javadoc().generate()) {
            this.javadoc().writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        for (Annotation annotation : this.annotations()) {
            annotation.writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        if (AccessModifier.PACKAGE_PRIVATE != this.accessModifier()) {
            writer.write(this.accessModifier().modifierName() + " ");
        }
        String typeName = this.type().simpleTypeName();
        writer.write(typeName + "(");
        boolean first = true;
        for (Parameter parameter : this.parameters()) {
            if (first) {
                first = false;
            } else {
                writer.write(", ");
            }
            parameter.writeComponent(writer, declaredTokens, imports, classType);
        }
        writer.write(")");
        this.writeThrows(writer, declaredTokens, imports, classType);
        writer.write(" {");
        if (this.hasBody()) {
            this.writeBody(writer, imports);
        } else {
            writer.write("\n");
        }
        writer.write("}");
    }

    public static final class Builder
    extends Executable.Builder<Builder, Constructor> {
        private Builder() {
        }

        public Constructor build() {
            return new Constructor(this);
        }
    }
}

