/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.Javadoc;
import java.util.ArrayList;
import java.util.List;

class JavadocParser {
    private JavadocParser() {
    }

    static Javadoc.Builder parse(Javadoc.Builder javadocBuilder, String docString) {
        return JavadocParser.parse(javadocBuilder, List.of(docString.split("\n")));
    }

    static Javadoc.Builder parse(Javadoc.Builder javadocBuilder, List<String> documentation) {
        ParserState state = ParserState.LINES;
        String currentTagName = null;
        ArrayList<String> currentTag = new ArrayList<String>();
        for (String raw : documentation) {
            String line = raw.trim();
            if (line.startsWith("@")) {
                int secondSpace;
                int space;
                JavadocParser.addTag(javadocBuilder, state, currentTagName, currentTag);
                currentTagName = null;
                currentTag.clear();
                if (line.startsWith("@param")) {
                    state = ParserState.PARAM;
                    space = line.indexOf(32);
                    if (space < 0) {
                        throw new IllegalStateException("Failed to parse javadoc, @param without param name: " + line);
                    }
                    secondSpace = line.indexOf(32, space + 2);
                    if (secondSpace < 0) {
                        throw new IllegalStateException("Failed to parse javadoc, @param without param name or docs: " + line);
                    }
                    currentTagName = line.substring(space + 1, secondSpace);
                    currentTag.add(line.substring(secondSpace + 1));
                    if (!currentTagName.startsWith("<")) continue;
                    currentTagName = currentTagName.substring(1, currentTagName.indexOf(">"));
                    state = ParserState.GENERIC_PARAM;
                    continue;
                }
                if (line.startsWith("@return")) {
                    state = ParserState.RETURNS;
                    currentTag.add(line.substring("@return".length()).trim());
                    continue;
                }
                if (line.startsWith("@throws")) {
                    state = ParserState.THROWS;
                    space = line.indexOf(32);
                    if (space < 0) {
                        throw new IllegalStateException("Failed to parse javadoc, @throws without exception name: " + line);
                    }
                    secondSpace = line.indexOf(32, space + 2);
                    if (secondSpace < 0) {
                        throw new IllegalStateException("Failed to parse javadoc, @throws without exception name or docs: " + line);
                    }
                    currentTagName = line.substring(space + 1, secondSpace);
                    currentTag.add(line.substring(secondSpace + 1));
                    continue;
                }
                state = ParserState.TAG;
                space = line.indexOf(32);
                if (space < 0) {
                    throw new IllegalStateException("Failed to parse javadoc, @tag without space: " + line);
                }
                currentTagName = line.substring(1, space);
                currentTag.add(line.substring(space + 1));
                continue;
            }
            if (state == ParserState.LINES) {
                javadocBuilder.addLine(raw);
                continue;
            }
            currentTag.add(line);
        }
        JavadocParser.addTag(javadocBuilder, state, currentTagName, currentTag);
        return javadocBuilder;
    }

    private static void addTag(Javadoc.Builder javadocBuilder, ParserState state, String currentTagName, List<String> currentTag) {
        if (state == ParserState.PARAM) {
            javadocBuilder.addParameter(currentTagName, currentTag);
        } else if (state == ParserState.GENERIC_PARAM) {
            javadocBuilder.addGenericArgument(currentTagName, currentTag);
        } else if (state == ParserState.TAG) {
            javadocBuilder.addTag(currentTagName, currentTag);
        } else if (state == ParserState.RETURNS) {
            javadocBuilder.returnDescription(currentTag);
        } else if (state == ParserState.THROWS) {
            javadocBuilder.addThrows(currentTagName, currentTag);
        }
    }

    private static enum ParserState {
        LINES,
        PARAM,
        GENERIC_PARAM,
        THROWS,
        RETURNS,
        TAG;

    }
}

