/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.ClassModelException;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.processor.classmodel.Type;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Content {
    private final StringBuilder content;
    private final Set<String> toImport;
    private final List<Position> tokenPositions;

    private Content(Builder builder) {
        this.content = new StringBuilder(builder.content);
        this.toImport = Set.copyOf(builder.toImport);
        this.tokenPositions = List.copyOf(builder.tokenPositions);
    }

    static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.content.toString();
    }

    boolean hasBody() {
        return !this.content.isEmpty();
    }

    void writeBody(ModelWriter writer, ImportOrganizer imports) throws IOException {
        int offset = 0;
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Position position : this.tokenPositions) {
            String replacement = replacements.computeIfAbsent(position.type, key -> {
                TypeName typeName = TypeName.create((String)key);
                return imports.typeName(Type.fromTypeName(typeName), true);
            });
            try {
                this.content.replace(position.start - offset, position.end - offset, replacement);
            }
            catch (StringIndexOutOfBoundsException e) {
                System.out.printf("", new Object[0]);
            }
            offset += position.end - position.start - replacement.length();
        }
        String[] lines = this.content.toString().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            writer.write(line);
            if (i + 1 == lines.length) continue;
            writer.write("\n");
        }
    }

    void addImports(ImportOrganizer.Builder builder) {
        this.toImport.forEach(builder::addImport);
    }

    static final class Builder
    implements io.helidon.common.Builder<Builder, Content> {
        private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("@(.*?)@");
        private final StringBuilder content = new StringBuilder();
        private final Set<String> toImport = new HashSet<String>();
        private final List<Position> tokenPositions = new ArrayList<Position>();
        private String extraPadding = "";
        private int extraPaddingLevel = 0;
        private boolean newLine = false;

        private Builder() {
        }

        public Content build() {
            this.toImport.clear();
            this.tokenPositions.clear();
            this.identifyClassTokens();
            return new Content(this);
        }

        Builder content(String content) {
            return this.content(List.of(content));
        }

        Builder content(List<String> content) {
            this.content.setLength(0);
            content.forEach(this::addLine);
            return (Builder)this.identity();
        }

        Builder addLine(String line) {
            return this.add(line).add("\n");
        }

        Builder add(String line) {
            String trimmed = line.trim();
            if (trimmed.equals("}")) {
                this.decreasePadding();
            }
            if (this.newLine) {
                this.content.append(this.extraPadding);
            }
            this.newLine = line.endsWith("\n");
            Object replacedLine = this.newLine ? line.substring(0, line.lastIndexOf("\n")).replaceAll("\n", "\n" + this.extraPadding) + "\n" : line.replaceAll("\n", "\n" + this.extraPadding);
            this.content.append((String)replacedLine);
            if (trimmed.endsWith("{")) {
                this.increasePadding();
            }
            return this;
        }

        Builder typeName(String fqClassName) {
            return this.add("@name@".replace("name", fqClassName));
        }

        Builder padding() {
            this.content.append("<<padding>>");
            return this;
        }

        Builder padding(int repetition) {
            this.content.append("<<padding>>".repeat(repetition));
            return this;
        }

        Builder increasePadding() {
            ++this.extraPaddingLevel;
            this.extraPadding = "<<padding>>".repeat(this.extraPaddingLevel);
            return this;
        }

        Builder decreasePadding() {
            --this.extraPaddingLevel;
            if (this.extraPaddingLevel < 0) {
                throw new ClassModelException("Content padding cannot be negative");
            }
            this.extraPadding = "<<padding>>".repeat(this.extraPaddingLevel);
            return this;
        }

        Builder clearContent() {
            this.content.setLength(0);
            return this;
        }

        private void identifyClassTokens() {
            Matcher matcher = TYPE_NAME_PATTERN.matcher(this.content);
            while (matcher.find()) {
                String className = matcher.group(1);
                this.toImport.add(className);
                this.tokenPositions.add(new Position(matcher.start(), matcher.end(), className));
            }
        }
    }

    private record Position(int start, int end, String type) {
    }
}

