/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.ConcreteType;
import io.helidon.common.processor.classmodel.ModelComponent;
import io.helidon.common.processor.classmodel.TypeArgument;
import io.helidon.common.types.TypeName;
import java.util.Optional;

abstract class Type
extends ModelComponent {
    Type(ModelComponent.Builder<?, ?> builder) {
        super(builder);
    }

    static Type fromTypeName(TypeName typeName) {
        if (typeName instanceof TypeArgument) {
            TypeArgument argument = (TypeArgument)typeName;
            return argument;
        }
        if (typeName.typeArguments().isEmpty()) {
            if (typeName.array() || Optional.class.getName().equals(typeName.declaredName())) {
                return ConcreteType.builder().type(TypeName.create((String)typeName.declaredName())).build();
            }
            if (typeName.wildcard()) {
                boolean isObject;
                boolean bl = isObject = typeName.name().equals("?") || Object.class.getName().equals(typeName.name());
                if (isObject) {
                    return TypeArgument.create("?");
                }
                return TypeArgument.builder().token("?").bound(Type.extractBoundTypeName(typeName.genericTypeName())).build();
            }
            return ConcreteType.builder().type(typeName).build();
        }
        ConcreteType.Builder typeBuilder = ConcreteType.builder().type(typeName);
        typeName.typeArguments().forEach(typeBuilder::addParam);
        return typeBuilder.build();
    }

    private static String extractBoundTypeName(TypeName instance) {
        String name = Type.calcName(instance);
        StringBuilder nameBuilder = new StringBuilder(name);
        if (!instance.typeArguments().isEmpty()) {
            nameBuilder.append("<");
            int i = 0;
            for (TypeName param : instance.typeArguments()) {
                if (i > 0) {
                    nameBuilder.append(", ");
                }
                nameBuilder.append(param.resolvedName());
                ++i;
            }
            nameBuilder.append(">");
        }
        if (instance.array()) {
            nameBuilder.append("[]");
        }
        return nameBuilder.toString();
    }

    private static String calcName(TypeName instance) {
        Object className = instance.enclosingNames().isEmpty() ? instance.className() : String.join((CharSequence)".", instance.enclosingNames()) + "." + instance.className();
        return instance.primitive() || instance.packageName().isEmpty() ? className : instance.packageName() + "." + (String)className;
    }

    abstract String fqTypeName();

    abstract String resolvedTypeName();

    abstract String packageName();

    abstract String simpleTypeName();

    abstract boolean isArray();

    abstract boolean innerClass();

    abstract Optional<Type> declaringClass();

    abstract TypeName genericTypeName();
}

