/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.LazyValue;
import io.helidon.common.socket.PeerInfo;
import io.helidon.common.socket.PlainSocket;
import io.helidon.common.socket.TlsSocket;
import java.net.SocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Optional;
import java.util.function.Supplier;

class PeerInfoImpl
implements PeerInfo {
    private final LazyValue<SocketAddress> socketAddress;
    private final LazyValue<String> host;
    private final LazyValue<Integer> port;
    private final Supplier<Optional<Principal>> principalSupplier;
    private final Supplier<Optional<Certificate[]>> certificateSupplier;

    private PeerInfoImpl(LazyValue<SocketAddress> socketAddress, LazyValue<String> host, LazyValue<Integer> port, Supplier<Optional<Principal>> principalSupplier, Supplier<Optional<Certificate[]>> certificateSupplier) {
        this.socketAddress = socketAddress;
        this.host = host;
        this.port = port;
        this.principalSupplier = principalSupplier;
        this.certificateSupplier = certificateSupplier;
    }

    static PeerInfo createLocal(PlainSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::localSocketAddress), (LazyValue<String>)LazyValue.create(socket::localHost), (LazyValue<Integer>)LazyValue.create(socket::localPort), Optional::empty, Optional::empty);
    }

    static PeerInfoImpl createLocal(TlsSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::localSocketAddress), (LazyValue<String>)LazyValue.create(socket::localHost), (LazyValue<Integer>)LazyValue.create(socket::localPort), socket::tlsPrincipal, socket::tlsCertificates);
    }

    static PeerInfoImpl createRemote(TlsSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::remoteSocketAddress), (LazyValue<String>)LazyValue.create(socket::remoteHost), (LazyValue<Integer>)LazyValue.create(socket::remotePort), socket::tlsPeerPrincipal, socket::tlsPeerCertificates);
    }

    static PeerInfoImpl createRemote(PlainSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::remoteSocketAddress), (LazyValue<String>)LazyValue.create(socket::remoteHost), (LazyValue<Integer>)LazyValue.create(socket::remotePort), Optional::empty, Optional::empty);
    }

    @Override
    public SocketAddress address() {
        return (SocketAddress)this.socketAddress.get();
    }

    @Override
    public String host() {
        return (String)this.host.get();
    }

    @Override
    public int port() {
        return (Integer)this.port.get();
    }

    @Override
    public Optional<Principal> tlsPrincipal() {
        return this.principalSupplier.get();
    }

    @Override
    public Optional<Certificate[]> tlsCertificates() {
        return this.certificateSupplier.get();
    }
}

