/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class SocketOptions {
    private final Map<SocketOption, Object> socketOptions;
    private final Duration connectTimeout;
    private final Duration readTimeout;

    private SocketOptions(Map<SocketOption, Object> socketOptions, Duration connectTimeout, Duration readTimeout) {
        this.socketOptions = new HashMap<SocketOption, Object>(socketOptions);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void configureSocket(Socket socket) {
        for (Map.Entry<SocketOption, Object> entry : this.socketOptions.entrySet()) {
            try {
                socket.setOption(entry.getKey(), entry.getValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public String toString() {
        return "SocketOptions{socketOptions=" + String.valueOf(this.socketOptions) + ", connectTimeout=" + String.valueOf(this.connectTimeout) + ", readTimeout=" + String.valueOf(this.readTimeout) + "}";
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, SocketOptions> {
        private static final int DEFAULT_SO_BUFFER_SIZE = 32768;
        private final Map<SocketOption, Object> socketOptions = new HashMap<SocketOption, Object>();
        private int socketReceiveBufferSize = 32768;
        private int socketSendBufferSize = 32768;
        private boolean socketReuseAddress = true;
        private boolean socketKeepAlive = true;
        private boolean tcpNoDelay = false;
        private Duration connectTimeout = Duration.ofSeconds(10L);
        private Duration readTimeout = Duration.ofSeconds(30L);

        private Builder() {
        }

        public final SocketOptions build() {
            this.socketOptions.put(StandardSocketOptions.SO_RCVBUF, this.socketReceiveBufferSize);
            this.socketOptions.put(StandardSocketOptions.SO_SNDBUF, this.socketSendBufferSize);
            this.socketOptions.put(StandardSocketOptions.SO_REUSEADDR, this.socketReuseAddress);
            this.socketOptions.put(StandardSocketOptions.SO_KEEPALIVE, this.socketKeepAlive);
            this.socketOptions.put(StandardSocketOptions.TCP_NODELAY, this.tcpNoDelay);
            return new SocketOptions(this.socketOptions, this.connectTimeout, this.readTimeout);
        }

        public Builder socketReceiveBufferSize(int socketReceiveBufferSize) {
            this.socketReceiveBufferSize = socketReceiveBufferSize;
            return this;
        }

        public Builder socketSendBufferSize(int socketSendBufferSize) {
            this.socketSendBufferSize = socketSendBufferSize;
            return this;
        }

        public Builder socketReuseAddress(boolean socketReuseAddress) {
            this.socketReuseAddress = socketReuseAddress;
            return this;
        }

        public Builder socketKeepAlive(boolean socketKeepAlive) {
            this.socketKeepAlive = socketKeepAlive;
            return this;
        }

        public Builder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public <O> Builder setOption(SocketOption<O> option, O value) {
            this.socketOptions.put(option, value);
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }
    }
}

