/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.PeerInfo;
import io.helidon.common.socket.PeerInfoImpl;
import io.helidon.common.socket.TlsSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;

public sealed class PlainSocket
implements HelidonSocket
permits TlsSocket {
    private static final int BUFFER_LENGTH = 8192;
    private final byte[] readBuffer = new byte[8192];
    private final Socket delegate;
    private final String childSocketId;
    private final String socketId;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    protected PlainSocket(Socket delegate, String childSocketId, String socketId) {
        this.delegate = delegate;
        this.childSocketId = childSocketId;
        this.socketId = socketId;
        try {
            this.inputStream = delegate.getInputStream();
            this.outputStream = delegate.getOutputStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static PlainSocket server(Socket delegate, String channelId, String serverChannelId) {
        return new PlainSocket(delegate, channelId, serverChannelId);
    }

    public static PlainSocket client(Socket delegate, String channelId) {
        return new PlainSocket(delegate, channelId, "client");
    }

    @Override
    public PeerInfo remotePeer() {
        return PeerInfoImpl.createRemote(this);
    }

    @Override
    public PeerInfo localPeer() {
        return PeerInfoImpl.createLocal(this);
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public String socketId() {
        return this.socketId;
    }

    @Override
    public String childSocketId() {
        return this.childSocketId;
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int read(BufferData buffer) {
        return buffer.readFrom(this.inputStream);
    }

    @Override
    public void write(BufferData buffer) {
        buffer.writeTo(this.outputStream);
    }

    @Override
    public byte[] get() {
        try {
            int r = this.inputStream.read(this.readBuffer);
            if (r == -1) {
                return null;
            }
            if (r == 0) {
                throw new IllegalStateException("Read 0 bytes, this should never happen with blocking socket");
            }
            return Arrays.copyOf(this.readBuffer, r);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SocketAddress localSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    SocketAddress remoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    String localHost() {
        SocketAddress localSocketAddress = this.localSocketAddress();
        if (localSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)localSocketAddress;
            return inet.getHostString();
        }
        throw new IllegalStateException("Local host is not an instance of InetSocketAddress");
    }

    String remoteHost() {
        SocketAddress remoteSocketAddress = this.delegate.getRemoteSocketAddress();
        if (remoteSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)remoteSocketAddress;
            return inet.getHostString();
        }
        throw new IllegalStateException("Remote host is not an instance of InetSocketAddress");
    }

    int localPort() {
        SocketAddress localSocketAddress = this.localSocketAddress();
        if (localSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)localSocketAddress;
            return inet.getPort();
        }
        throw new IllegalStateException("Local host is not an instance of InetSocketAddress");
    }

    int remotePort() {
        SocketAddress remoteSocketAddress = this.delegate.getRemoteSocketAddress();
        if (remoteSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)remoteSocketAddress;
            return inet.getPort();
        }
        throw new IllegalStateException("Remote host is not an instance of InetSocketAddress");
    }
}

