/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.context.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.context.http.ContextRecordConfigBlueprint;
import io.helidon.common.context.http.ContextRecordConfigSupport;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.http.HeaderName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.context.http.ContextRecordConfigBlueprint")
public interface ContextRecordConfig
extends ContextRecordConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContextRecordConfig instance) {
        return (Builder)ContextRecordConfig.builder().from(instance);
    }

    public static ContextRecordConfig create(Config config) {
        return ((Builder)ContextRecordConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static ContextRecordConfig create(io.helidon.common.config.Config config) {
        return ContextRecordConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static ContextRecordConfig create() {
        return ContextRecordConfig.builder().buildPrototype();
    }

    @Override
    public HeaderName header();

    @Override
    public Optional<String> classifier();

    @Override
    public Optional<String> defaultValue();

    @Override
    public List<String> defaultValues();

    @Override
    public boolean array();

    public static class Builder
    extends BuilderBase<Builder, ContextRecordConfig>
    implements io.helidon.common.Builder<Builder, ContextRecordConfig> {
        private Builder() {
        }

        public ContextRecordConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ContextRecordConfigImpl(this);
        }

        public ContextRecordConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ContextRecordConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<String> defaultValues = new ArrayList<String>();
        private boolean array;
        private boolean isDefaultValuesMutated;
        private Config config;
        private HeaderName header;
        private String classifier;
        private String defaultValue;

        protected BuilderBase() {
        }

        public BUILDER from(ContextRecordConfig prototype) {
            this.header(prototype.header());
            this.classifier(prototype.classifier());
            this.defaultValue(prototype.defaultValue());
            if (!this.isDefaultValuesMutated) {
                this.defaultValues.clear();
            }
            this.addDefaultValues(prototype.defaultValues());
            this.array(prototype.array());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.header().ifPresent(this::header);
            builder.classifier().ifPresent(this::classifier);
            builder.defaultValue().ifPresent(this::defaultValue);
            if (this.isDefaultValuesMutated) {
                if (builder.isDefaultValuesMutated) {
                    this.addDefaultValues(builder.defaultValues);
                }
            } else {
                this.defaultValues.clear();
                this.addDefaultValues(builder.defaultValues);
            }
            this.array(builder.array());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("header").as(ContextRecordConfigSupport.RecordCustomMethods::createHeader).ifPresent(this::header);
            config.get("classifier").as(String.class).ifPresent(this::classifier);
            config.get("default-value").as(String.class).ifPresent(this::defaultValue);
            config.get("default-values").asList(String.class).ifPresent(this::defaultValues);
            config.get("array").as(Boolean.class).ifPresent(this::array);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER header(HeaderName header) {
            Objects.requireNonNull(header);
            this.header = header;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearClassifier() {
            this.classifier = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER classifier(String classifier) {
            Objects.requireNonNull(classifier);
            this.classifier = classifier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDefaultValue() {
            this.defaultValue = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultValue(String defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultValues(List<String> defaultValues) {
            Objects.requireNonNull(defaultValues);
            this.isDefaultValuesMutated = true;
            this.defaultValues.clear();
            this.defaultValues.addAll(defaultValues);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDefaultValues(List<String> defaultValues) {
            Objects.requireNonNull(defaultValues);
            this.isDefaultValuesMutated = true;
            this.defaultValues.addAll(defaultValues);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDefaultValue(String defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValues.add(defaultValue);
            this.isDefaultValuesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER array(boolean array) {
            this.array = array;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<HeaderName> header() {
            return Optional.ofNullable(this.header);
        }

        public Optional<String> classifier() {
            return Optional.ofNullable(this.classifier);
        }

        public Optional<String> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public List<String> defaultValues() {
            return this.defaultValues;
        }

        public boolean array() {
            return this.array;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ContextRecordConfigBuilder{header=" + String.valueOf(this.header) + ",classifier=" + this.classifier + ",defaultValue=" + this.defaultValue + ",defaultValues=" + String.valueOf(this.defaultValues) + ",array=" + this.array + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.header == null) {
                collector.fatal(this.getClass(), "Property \"header\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER classifier(Optional<String> classifier) {
            Objects.requireNonNull(classifier);
            this.classifier = classifier.map(String.class::cast).orElse(this.classifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER defaultValue(Optional<String> defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue.map(String.class::cast).orElse(this.defaultValue);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ContextRecordConfigImpl
        implements ContextRecordConfig {
            private final boolean array;
            private final HeaderName header;
            private final List<String> defaultValues;
            private final Optional<String> classifier;
            private final Optional<String> defaultValue;

            protected ContextRecordConfigImpl(BuilderBase<?, ?> builder) {
                this.header = builder.header().get();
                this.classifier = builder.classifier().map(Function.identity());
                this.defaultValue = builder.defaultValue().map(Function.identity());
                this.defaultValues = List.copyOf(builder.defaultValues());
                this.array = builder.array();
            }

            @Override
            public HeaderName header() {
                return this.header;
            }

            @Override
            public Optional<String> classifier() {
                return this.classifier;
            }

            @Override
            public Optional<String> defaultValue() {
                return this.defaultValue;
            }

            @Override
            public List<String> defaultValues() {
                return this.defaultValues;
            }

            @Override
            public boolean array() {
                return this.array;
            }

            public String toString() {
                return "ContextRecordConfig{header=" + String.valueOf(this.header) + ",classifier=" + String.valueOf(this.classifier) + ",defaultValue=" + String.valueOf(this.defaultValue) + ",defaultValues=" + String.valueOf(this.defaultValues) + ",array=" + this.array + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContextRecordConfig)) {
                    return false;
                }
                ContextRecordConfig other = (ContextRecordConfig)o;
                return Objects.equals(this.header, other.header()) && Objects.equals(this.classifier, other.classifier()) && Objects.equals(this.defaultValue, other.defaultValue()) && Objects.equals(this.defaultValues, other.defaultValues()) && this.array == other.array();
            }

            public int hashCode() {
                return Objects.hash(this.header, this.classifier, this.defaultValue, this.defaultValues, this.array);
            }
        }
    }
}

