/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenLogger;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.CodegenScope;
import io.helidon.codegen.Option;
import io.helidon.codegen.spi.AnnotationMapper;
import io.helidon.codegen.spi.AnnotationMapperProvider;
import io.helidon.codegen.spi.CodegenProvider;
import io.helidon.codegen.spi.ElementMapper;
import io.helidon.codegen.spi.ElementMapperProvider;
import io.helidon.codegen.spi.TypeMapper;
import io.helidon.codegen.spi.TypeMapperProvider;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public abstract class CodegenContextBase
implements CodegenContext {
    private final Map<TypeName, Map<String, ElementSignatures>> uniqueNames = new HashMap<TypeName, Map<String, ElementSignatures>>();
    private final List<ElementMapper> elementMappers;
    private final List<TypeMapper> typeMappers;
    private final List<AnnotationMapper> annotationMappers;
    private final Set<Option<?>> supportedOptions;
    private final Set<String> supportedPackages;
    private final Set<TypeName> supportedAnnotations;
    private final CodegenOptions options;
    private final CodegenFiler filer;
    private final CodegenLogger logger;
    private final CodegenScope scope;

    protected CodegenContextBase(CodegenOptions options, Set<Option<?>> additionalOptions, CodegenFiler filer, CodegenLogger logger, CodegenScope scope) {
        this.options = options;
        this.filer = filer;
        this.logger = logger;
        this.scope = scope;
        HashSet supportedOptions = new HashSet(additionalOptions);
        HashSet supportedPackages = new HashSet();
        HashSet supportedAnnotations = new HashSet();
        this.annotationMappers = HelidonServiceLoader.create(ServiceLoader.load(AnnotationMapperProvider.class, CodegenContextBase.class.getClassLoader())).stream().peek(it -> CodegenContextBase.addSupported(it, supportedOptions, supportedPackages, supportedAnnotations)).map(it -> it.create(options)).toList();
        this.elementMappers = HelidonServiceLoader.create(ServiceLoader.load(ElementMapperProvider.class, CodegenContextBase.class.getClassLoader())).stream().peek(it -> CodegenContextBase.addSupported(it, supportedOptions, supportedPackages, supportedAnnotations)).map(it -> it.create(options)).toList();
        this.typeMappers = HelidonServiceLoader.create(ServiceLoader.load(TypeMapperProvider.class, CodegenContextBase.class.getClassLoader())).stream().peek(it -> CodegenContextBase.addSupported(it, supportedOptions, supportedPackages, supportedAnnotations)).map(it -> it.create(options)).toList();
        this.supportedOptions = Set.copyOf(supportedOptions);
        this.supportedPackages = Set.copyOf(supportedPackages);
        this.supportedAnnotations = Set.copyOf(supportedAnnotations);
        supportedOptions.forEach(it -> it.findValue(options));
    }

    @Override
    public List<ElementMapper> elementMappers() {
        return this.elementMappers;
    }

    @Override
    public List<TypeMapper> typeMappers() {
        return this.typeMappers;
    }

    @Override
    public List<AnnotationMapper> annotationMappers() {
        return this.annotationMappers;
    }

    @Override
    public Set<TypeName> mapperSupportedAnnotations() {
        return this.supportedAnnotations;
    }

    @Override
    public Set<String> mapperSupportedAnnotationPackages() {
        return this.supportedPackages;
    }

    @Override
    public Set<Option<?>> supportedOptions() {
        return this.supportedOptions;
    }

    @Override
    public CodegenFiler filer() {
        return this.filer;
    }

    @Override
    public CodegenLogger logger() {
        return this.logger;
    }

    @Override
    public CodegenScope scope() {
        return this.scope;
    }

    @Override
    public CodegenOptions options() {
        return this.options;
    }

    @Override
    public String uniqueName(TypeInfo type, TypedElementInfo element) {
        return this.uniqueNames.computeIfAbsent(type.typeName(), it -> new HashMap()).computeIfAbsent(element.elementName(), ElementSignatures::new).uniqueName(element.signature());
    }

    private static void addSupported(CodegenProvider provider, Set<Option<?>> supportedOptions, Set<String> supportedPackages, Set<TypeName> supportedAnnotations) {
        supportedOptions.addAll(provider.supportedOptions());
        supportedAnnotations.addAll(provider.supportedAnnotations());
        provider.supportedAnnotationPackages().stream().map(it -> it.endsWith(".*") ? it : it + ".*").forEach(supportedPackages::add);
    }

    private static class ElementSignatures {
        private final Map<ElementSignature, String> names = new HashMap<ElementSignature, String>();
        private final String name;

        private ElementSignatures(String name) {
            this.name = name;
        }

        public String uniqueName(ElementSignature signature) {
            int size = this.names.size();
            if (this.names.containsKey(signature)) {
                return this.names.get(signature);
            }
            String nextName = size == 0 ? this.name : this.name + "_" + size;
            this.names.put(signature, nextName);
            return nextName;
        }
    }
}

