/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.FilerTextResource;
import java.util.ArrayList;
import java.util.List;

public class ManifestResource {
    private final FilerTextResource manifestResource;
    private final List<String> locations;
    private boolean modified;

    private ManifestResource(FilerTextResource manifestResource, List<String> locations) {
        this.manifestResource = manifestResource;
        this.locations = locations;
    }

    public static ManifestResource create(CodegenFiler filer) {
        FilerTextResource manifestResource = filer.textResource("META-INF/helidon/manifest", new Object[0]);
        ArrayList<String> lines = new ArrayList<String>(manifestResource.lines());
        if (lines.isEmpty()) {
            lines.add("#HELIDON MANIFEST#");
        }
        return new ManifestResource(manifestResource, lines);
    }

    public void add(String resourceLocation) {
        if (!this.locations.contains(resourceLocation)) {
            this.locations.add(resourceLocation);
            this.modified = true;
        }
    }

    public void write() {
        if (this.modified) {
            this.manifestResource.lines(this.locations);
            this.manifestResource.write();
        }
    }
}

