/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.ModuleInfoRequires;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public interface ModuleInfo {
    public static final String DEFAULT_MODULE_NAME = "unnamed";
    public static final String FILE_NAME = "module-info.java";

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModuleInfo instance) {
        return (Builder)ModuleInfo.builder().from(instance);
    }

    public String name();

    public boolean isOpen();

    public List<ModuleInfoRequires> requires();

    public Map<String, List<String>> exports();

    public List<TypeName> uses();

    public Map<TypeName, List<TypeName>> provides();

    public Map<String, List<String>> opens();

    default public Optional<String> firstUnqualifiedExport() {
        return this.exports().entrySet().stream().filter(it -> ((List)it.getValue()).isEmpty()).map(Map.Entry::getKey).findFirst();
    }

    public static class Builder
    extends BuilderBase<Builder>
    implements io.helidon.common.Builder<Builder, ModuleInfo> {
        private Builder() {
        }

        public ModuleInfo build() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ModuleInfoImpl(this);
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER>>
    implements io.helidon.common.Builder<BUILDER, ModuleInfo> {
        private final List<TypeName> uses = new ArrayList<TypeName>();
        private final List<ModuleInfoRequires> requires = new ArrayList<ModuleInfoRequires>();
        private final Map<String, List<String>> exports = new LinkedHashMap<String, List<String>>();
        private final Map<TypeName, List<TypeName>> provides = new LinkedHashMap<TypeName, List<TypeName>>();
        private final Map<String, List<String>> opens = new LinkedHashMap<String, List<String>>();
        private boolean isOpen = false;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(ModuleInfo prototype) {
            this.name(prototype.name());
            this.isOpen(prototype.isOpen());
            this.addRequires(prototype.requires());
            this.addExports(prototype.exports());
            this.addUses(prototype.uses());
            this.addProvides(prototype.provides());
            this.addOpens(prototype.opens());
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER from(BuilderBase<?> builder) {
            builder.name().ifPresent(this::name);
            this.isOpen(builder.isOpen());
            this.addRequires(builder.requires());
            this.addExports(builder.exports());
            this.addUses(builder.uses());
            this.addProvides(builder.provides());
            this.addOpens(builder.opens());
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER isOpen(boolean isOpen) {
            this.isOpen = isOpen;
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER requires(List<? extends ModuleInfoRequires> requires) {
            Objects.requireNonNull(requires);
            this.requires.clear();
            this.requires.addAll(requires);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addRequires(List<? extends ModuleInfoRequires> requires) {
            Objects.requireNonNull(requires);
            this.requires.addAll(requires);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addRequire(ModuleInfoRequires require) {
            Objects.requireNonNull(require);
            this.requires.add(require);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER exports(Map<? extends String, List<String>> exports) {
            Objects.requireNonNull(exports);
            this.exports.clear();
            this.exports.putAll(exports);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addExports(Map<? extends String, List<String>> exports) {
            Objects.requireNonNull(exports);
            this.exports.putAll(exports);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER putExports(String packageName, List<String> moduleNames) {
            Objects.requireNonNull(packageName);
            Objects.requireNonNull(moduleNames);
            this.exports.put(packageName, List.copyOf(moduleNames));
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addExport(String export, String to) {
            Objects.requireNonNull(export);
            Objects.requireNonNull(to);
            this.opens.compute(export, (k, v) -> {
                v = v == null ? new ArrayList<String>() : new ArrayList(v);
                v.add(to);
                return v;
            });
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER uses(List<? extends TypeName> uses) {
            Objects.requireNonNull(uses);
            this.uses.clear();
            this.uses.addAll(uses);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addUses(List<? extends TypeName> uses) {
            Objects.requireNonNull(uses);
            this.uses.addAll(uses);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addUse(TypeName use) {
            Objects.requireNonNull(use);
            this.uses.add(use);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addUse(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.uses.add(builder.build());
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER provides(Map<? extends TypeName, List<TypeName>> provides) {
            Objects.requireNonNull(provides);
            this.provides.clear();
            this.provides.putAll(provides);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addProvides(Map<? extends TypeName, List<TypeName>> provides) {
            Objects.requireNonNull(provides);
            this.provides.putAll(provides);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addProvide(TypeName key, TypeName provide) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(provide);
            this.provides.compute(key, (k, v) -> {
                v = v == null ? new ArrayList<TypeName>() : new ArrayList(v);
                v.add(provide);
                return v;
            });
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addProvides(TypeName key, List<TypeName> provides) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(provides);
            this.provides.compute(key, (k, v) -> {
                v = v == null ? new ArrayList() : new ArrayList(v);
                v.addAll(provides);
                return v;
            });
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER putProvide(TypeName key, List<TypeName> provide) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(provide);
            this.provides.put(key, List.copyOf(provide));
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER opens(Map<? extends String, List<String>> opens) {
            Objects.requireNonNull(opens);
            this.opens.clear();
            this.opens.putAll(opens);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addOpens(Map<? extends String, List<String>> opens) {
            Objects.requireNonNull(opens);
            this.opens.putAll(opens);
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addOpen(String key, String open) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(open);
            this.opens.compute(key, (k, v) -> {
                v = v == null ? new ArrayList<String>() : new ArrayList(v);
                v.add(open);
                return v;
            });
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER addOpens(String key, List<String> opens) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(opens);
            this.opens.compute(key, (k, v) -> {
                v = v == null ? new ArrayList() : new ArrayList(v);
                v.addAll(opens);
                return v;
            });
            return (BUILDER)((BuilderBase)this.identity());
        }

        public BUILDER putOpen(String key, List<String> open) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(open);
            this.opens.put(key, List.copyOf(open));
            return (BUILDER)((BuilderBase)this.identity());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public List<ModuleInfoRequires> requires() {
            return this.requires;
        }

        public Map<String, List<String>> exports() {
            return this.exports;
        }

        public List<TypeName> uses() {
            return this.uses;
        }

        public Map<TypeName, List<TypeName>> provides() {
            return this.provides;
        }

        public Map<String, List<String>> opens() {
            return this.opens;
        }

        public String toString() {
            return "ModuleInfoBuilder{name=" + this.name + ",isOpen=" + this.isOpen + ",requires=" + String.valueOf(this.requires) + ",exports=" + String.valueOf(this.exports) + ",uses=" + String.valueOf(this.uses) + ",provides=" + String.valueOf(this.provides) + ",opens=" + String.valueOf(this.opens) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class ModuleInfoImpl
        implements ModuleInfo {
            private final boolean isOpen;
            private final List<TypeName> uses;
            private final List<ModuleInfoRequires> requires;
            private final Map<String, List<String>> exports;
            private final Map<TypeName, List<TypeName>> provides;
            private final Map<String, List<String>> opens;
            private final String name;

            protected ModuleInfoImpl(BuilderBase<?> builder) {
                this.name = builder.name().get();
                this.isOpen = builder.isOpen();
                this.requires = List.copyOf(builder.requires());
                this.exports = Map.copyOf(builder.exports());
                this.uses = List.copyOf(builder.uses());
                this.provides = Collections.unmodifiableMap(new LinkedHashMap<TypeName, List<TypeName>>(builder.provides()));
                this.opens = Collections.unmodifiableMap(new LinkedHashMap<String, List<String>>(builder.opens()));
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public boolean isOpen() {
                return this.isOpen;
            }

            @Override
            public List<ModuleInfoRequires> requires() {
                return this.requires;
            }

            @Override
            public Map<String, List<String>> exports() {
                return this.exports;
            }

            @Override
            public List<TypeName> uses() {
                return this.uses;
            }

            @Override
            public Map<TypeName, List<TypeName>> provides() {
                return this.provides;
            }

            @Override
            public Map<String, List<String>> opens() {
                return this.opens;
            }

            public String toString() {
                return "ModuleInfo{name=" + this.name + ",isOpen=" + this.isOpen + ",requires=" + String.valueOf(this.requires) + ",exports=" + String.valueOf(this.exports) + ",uses=" + String.valueOf(this.uses) + ",provides=" + String.valueOf(this.provides) + ",opens=" + String.valueOf(this.opens) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ModuleInfo)) {
                    return false;
                }
                ModuleInfo other = (ModuleInfo)o;
                return Objects.equals(this.name, other.name()) && this.isOpen == other.isOpen() && Objects.equals(this.requires, other.requires()) && Objects.equals(this.exports, other.exports()) && Objects.equals(this.uses, other.uses()) && Objects.equals(this.provides, other.provides()) && Objects.equals(this.opens, other.opens());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.isOpen, this.requires, this.exports, this.uses, this.provides, this.opens);
            }
        }
    }
}

