/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.scan;

import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationEnumValue;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassInfo;
import io.helidon.codegen.scan.ScanContext;
import io.helidon.codegen.scan.ScanTypeFactory;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.EnumValue;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class ScanAnnotationFactory {
    private ScanAnnotationFactory() {
    }

    public static Annotation createAnnotation(ScanContext ctx, AnnotationInfo am) {
        TypeName typeName = ScanTypeFactory.create(am.getClassInfo());
        HashSet<TypeName> set = new HashSet<TypeName>();
        set.add(TypeNames.INHERITED);
        set.add(TypeNames.TARGET);
        set.add(TypeNames.RETENTION);
        set.add(TypeNames.DOCUMENTED);
        set.remove(typeName);
        return ScanAnnotationFactory.createAnnotation(ctx, am, set).orElseThrow();
    }

    private static Optional<Annotation> createAnnotation(ScanContext ctx, AnnotationInfo am, HashSet<TypeName> processedTypes) {
        ClassInfo classInfo = am.getClassInfo();
        if (classInfo == null) {
            return Optional.empty();
        }
        TypeName typeName = ScanTypeFactory.create(classInfo);
        if (processedTypes.contains(typeName)) {
            return Optional.empty();
        }
        Annotation.Builder builder = Annotation.builder();
        classInfo.getAnnotationInfo().stream().map(it -> {
            HashSet<TypeName> newProcessed = new HashSet<TypeName>(processedTypes);
            newProcessed.add(typeName);
            return ScanAnnotationFactory.createAnnotation(ctx, it, newProcessed);
        }).flatMap(Optional::stream).forEach(arg_0 -> ((Annotation.Builder)builder).addMetaAnnotation(arg_0));
        return Optional.of(((Annotation.Builder)((Annotation.Builder)builder.typeName(typeName)).values(ScanAnnotationFactory.extractAnnotationValues(ctx, am))).build());
    }

    private static Map<String, Object> extractAnnotationValues(ScanContext ctx, AnnotationInfo am) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        AnnotationParameterValueList parameterValues = am.getParameterValues();
        for (AnnotationParameterValue parameterValue : parameterValues) {
            String name = parameterValue.getName();
            Object value = parameterValue.getValue();
            if (value == null) continue;
            result.put(name, ScanAnnotationFactory.toAnnotationValue(ctx, value));
        }
        return result;
    }

    private static Object toAnnotationValue(ScanContext ctx, Object scanAnnotationValue) {
        if (scanAnnotationValue.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            int length = Array.getLength(scanAnnotationValue);
            for (int i = 0; i < length; ++i) {
                result.add(ScanAnnotationFactory.toAnnotationValue(ctx, Array.get(scanAnnotationValue, i)));
            }
            return result;
        }
        Object object = scanAnnotationValue;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationEnumValue.class, AnnotationClassRef.class, AnnotationInfo.class}, (Object)object2, n)) {
            case 0 -> {
                AnnotationEnumValue anEnum = (AnnotationEnumValue)object2;
                yield EnumValue.create((TypeName)TypeName.create((String)anEnum.getClassName()), (String)anEnum.getValueName());
            }
            case 1 -> {
                AnnotationClassRef aClass = (AnnotationClassRef)object2;
                yield TypeName.create((String)aClass.getName());
            }
            case 2 -> {
                AnnotationInfo annotation = (AnnotationInfo)object2;
                yield ScanAnnotationFactory.createAnnotation(ctx, annotation);
            }
            default -> scanAnnotationValue;
        };
    }
}

