/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.compiler;

import io.helidon.builder.api.Prototype;
import io.helidon.codegen.CodegenLogger;
import io.helidon.codegen.compiler.CompilerOptionsBlueprint;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.codegen.compiler.CompilerOptionsBlueprint")
public interface CompilerOptions
extends CompilerOptionsBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CompilerOptions instance) {
        return (Builder)CompilerOptions.builder().from(instance);
    }

    public static CompilerOptions create() {
        return CompilerOptions.builder().buildPrototype();
    }

    @Override
    public List<Path> classpath();

    @Override
    public List<Path> modulepath();

    @Override
    public List<Path> sourcepath();

    @Override
    public List<String> commandLineArguments();

    @Override
    public String source();

    @Override
    public String target();

    @Override
    public Optional<String> release();

    @Override
    public Path outputDirectory();

    @Override
    public CodegenLogger logger();

    public static class Builder
    extends BuilderBase<Builder, CompilerOptions>
    implements io.helidon.common.Builder<Builder, CompilerOptions> {
        private Builder() {
        }

        public CompilerOptions buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.CompilerOptionsImpl(this);
        }

        public CompilerOptions build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends CompilerOptions>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<String> commandLineArguments = new ArrayList<String>();
        private final List<Path> classpath = new ArrayList<Path>();
        private final List<Path> modulepath = new ArrayList<Path>();
        private final List<Path> sourcepath = new ArrayList<Path>();
        private boolean isClasspathMutated;
        private boolean isCommandLineArgumentsMutated;
        private boolean isModulepathMutated;
        private boolean isSourcepathMutated;
        private CodegenLogger logger = CodegenLogger.create((System.Logger)System.getLogger("io.helidon.codegen.compiler.Compiler"));
        private Path outputDirectory;
        private String release;
        private String source = "21";
        private String target = "21";

        protected BuilderBase() {
        }

        public BUILDER from(CompilerOptions prototype) {
            if (!this.isClasspathMutated) {
                this.classpath.clear();
            }
            this.addClasspath(prototype.classpath());
            if (!this.isModulepathMutated) {
                this.modulepath.clear();
            }
            this.addModulepath(prototype.modulepath());
            if (!this.isSourcepathMutated) {
                this.sourcepath.clear();
            }
            this.addSourcepath(prototype.sourcepath());
            if (!this.isCommandLineArgumentsMutated) {
                this.commandLineArguments.clear();
            }
            this.addCommandLineArguments(prototype.commandLineArguments());
            this.source(prototype.source());
            this.target(prototype.target());
            this.release(prototype.release());
            this.outputDirectory(prototype.outputDirectory());
            this.logger(prototype.logger());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isClasspathMutated) {
                if (builder.isClasspathMutated) {
                    this.addClasspath(builder.classpath);
                }
            } else {
                this.classpath.clear();
                this.addClasspath(builder.classpath);
            }
            if (this.isModulepathMutated) {
                if (builder.isModulepathMutated) {
                    this.addModulepath(builder.modulepath);
                }
            } else {
                this.modulepath.clear();
                this.addModulepath(builder.modulepath);
            }
            if (this.isSourcepathMutated) {
                if (builder.isSourcepathMutated) {
                    this.addSourcepath(builder.sourcepath);
                }
            } else {
                this.sourcepath.clear();
                this.addSourcepath(builder.sourcepath);
            }
            if (this.isCommandLineArgumentsMutated) {
                if (builder.isCommandLineArgumentsMutated) {
                    this.addCommandLineArguments(builder.commandLineArguments);
                }
            } else {
                this.commandLineArguments.clear();
                this.addCommandLineArguments(builder.commandLineArguments);
            }
            this.source(builder.source());
            this.target(builder.target());
            builder.release().ifPresent(this::release);
            builder.outputDirectory().ifPresent(this::outputDirectory);
            this.logger(builder.logger());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER classpath(List<? extends Path> classpath) {
            Objects.requireNonNull(classpath);
            this.isClasspathMutated = true;
            this.classpath.clear();
            this.classpath.addAll(classpath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addClasspath(List<? extends Path> classpath) {
            Objects.requireNonNull(classpath);
            this.isClasspathMutated = true;
            this.classpath.addAll(classpath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addClasspath(Path classpath) {
            Objects.requireNonNull(classpath);
            this.classpath.add(classpath);
            this.isClasspathMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER modulepath(List<? extends Path> modulepath) {
            Objects.requireNonNull(modulepath);
            this.isModulepathMutated = true;
            this.modulepath.clear();
            this.modulepath.addAll(modulepath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addModulepath(List<? extends Path> modulepath) {
            Objects.requireNonNull(modulepath);
            this.isModulepathMutated = true;
            this.modulepath.addAll(modulepath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addModulepath(Path modulepath) {
            Objects.requireNonNull(modulepath);
            this.modulepath.add(modulepath);
            this.isModulepathMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sourcepath(List<? extends Path> sourcepath) {
            Objects.requireNonNull(sourcepath);
            this.isSourcepathMutated = true;
            this.sourcepath.clear();
            this.sourcepath.addAll(sourcepath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSourcepath(List<? extends Path> sourcepath) {
            Objects.requireNonNull(sourcepath);
            this.isSourcepathMutated = true;
            this.sourcepath.addAll(sourcepath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSourcepath(Path sourcepath) {
            Objects.requireNonNull(sourcepath);
            this.sourcepath.add(sourcepath);
            this.isSourcepathMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER commandLineArguments(List<String> commandLineArguments) {
            Objects.requireNonNull(commandLineArguments);
            this.isCommandLineArgumentsMutated = true;
            this.commandLineArguments.clear();
            this.commandLineArguments.addAll(commandLineArguments);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCommandLineArguments(List<String> commandLineArguments) {
            Objects.requireNonNull(commandLineArguments);
            this.isCommandLineArgumentsMutated = true;
            this.commandLineArguments.addAll(commandLineArguments);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCommandLineArgument(String commandLineArgument) {
            Objects.requireNonNull(commandLineArgument);
            this.commandLineArguments.add(commandLineArgument);
            this.isCommandLineArgumentsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER source(String source) {
            Objects.requireNonNull(source);
            this.source = source;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER target(String target) {
            Objects.requireNonNull(target);
            this.target = target;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRelease() {
            this.release = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER release(String release) {
            Objects.requireNonNull(release);
            this.release = release;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER outputDirectory(Path outputDirectory) {
            Objects.requireNonNull(outputDirectory);
            this.outputDirectory = outputDirectory;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logger(CodegenLogger logger) {
            Objects.requireNonNull(logger);
            this.logger = logger;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<Path> classpath() {
            return this.classpath;
        }

        public List<Path> modulepath() {
            return this.modulepath;
        }

        public List<Path> sourcepath() {
            return this.sourcepath;
        }

        public List<String> commandLineArguments() {
            return this.commandLineArguments;
        }

        public String source() {
            return this.source;
        }

        public String target() {
            return this.target;
        }

        public Optional<String> release() {
            return Optional.ofNullable(this.release);
        }

        public Optional<Path> outputDirectory() {
            return Optional.ofNullable(this.outputDirectory);
        }

        public CodegenLogger logger() {
            return this.logger;
        }

        public String toString() {
            return "CompilerOptionsBuilder{classpath=" + String.valueOf(this.classpath) + ",modulepath=" + String.valueOf(this.modulepath) + ",sourcepath=" + String.valueOf(this.sourcepath) + ",commandLineArguments=" + String.valueOf(this.commandLineArguments) + ",source=" + this.source + ",target=" + this.target + ",release=" + this.release + ",outputDirectory=" + String.valueOf(this.outputDirectory) + ",logger=" + String.valueOf(this.logger) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.outputDirectory == null) {
                collector.fatal(this.getClass(), "Property \"outputDirectory\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER release(Optional<String> release) {
            Objects.requireNonNull(release);
            this.release = release.map(String.class::cast).orElse(this.release);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class CompilerOptionsImpl
        implements CompilerOptions {
            private final CodegenLogger logger;
            private final List<String> commandLineArguments;
            private final List<Path> classpath;
            private final List<Path> modulepath;
            private final List<Path> sourcepath;
            private final Optional<String> release;
            private final Path outputDirectory;
            private final String source;
            private final String target;

            protected CompilerOptionsImpl(BuilderBase<?, ?> builder) {
                this.classpath = List.copyOf(builder.classpath());
                this.modulepath = List.copyOf(builder.modulepath());
                this.sourcepath = List.copyOf(builder.sourcepath());
                this.commandLineArguments = List.copyOf(builder.commandLineArguments());
                this.source = builder.source();
                this.target = builder.target();
                this.release = builder.release().map(Function.identity());
                this.outputDirectory = builder.outputDirectory().get();
                this.logger = builder.logger();
            }

            @Override
            public List<Path> classpath() {
                return this.classpath;
            }

            @Override
            public List<Path> modulepath() {
                return this.modulepath;
            }

            @Override
            public List<Path> sourcepath() {
                return this.sourcepath;
            }

            @Override
            public List<String> commandLineArguments() {
                return this.commandLineArguments;
            }

            @Override
            public String source() {
                return this.source;
            }

            @Override
            public String target() {
                return this.target;
            }

            @Override
            public Optional<String> release() {
                return this.release;
            }

            @Override
            public Path outputDirectory() {
                return this.outputDirectory;
            }

            @Override
            public CodegenLogger logger() {
                return this.logger;
            }

            public String toString() {
                return "CompilerOptions{classpath=" + String.valueOf(this.classpath) + ",modulepath=" + String.valueOf(this.modulepath) + ",sourcepath=" + String.valueOf(this.sourcepath) + ",commandLineArguments=" + String.valueOf(this.commandLineArguments) + ",source=" + this.source + ",target=" + this.target + ",release=" + String.valueOf(this.release) + ",outputDirectory=" + String.valueOf(this.outputDirectory) + ",logger=" + String.valueOf(this.logger) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CompilerOptions)) {
                    return false;
                }
                CompilerOptions other = (CompilerOptions)o;
                return Objects.equals(this.classpath, other.classpath()) && Objects.equals(this.modulepath, other.modulepath()) && Objects.equals(this.sourcepath, other.sourcepath()) && Objects.equals(this.commandLineArguments, other.commandLineArguments()) && Objects.equals(this.source, other.source()) && Objects.equals(this.target, other.target()) && Objects.equals(this.release, other.release()) && Objects.equals(this.outputDirectory, other.outputDirectory()) && Objects.equals(this.logger, other.logger());
            }

            public int hashCode() {
                return Objects.hash(this.classpath, this.modulepath, this.sourcepath, this.commandLineArguments, this.source, this.target, this.release, this.outputDirectory, this.logger);
            }
        }
    }
}

