/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.ModelComponent;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Type;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class TypeArgument
extends Type
implements TypeName {
    private final TypeName token;
    private final List<Type> bounds;
    private final List<String> description;
    private final boolean isLowerBound;

    private TypeArgument(Builder builder) {
        super(builder);
        this.token = builder.tokenBuilder.build();
        this.bounds = List.copyOf(builder.bounds);
        this.description = builder.description;
        this.isLowerBound = builder.isLowerBound;
    }

    public static TypeArgument create(String token) {
        return TypeArgument.builder().token(token).build();
    }

    public static TypeArgument create(TypeName typeName) {
        Builder builder = TypeArgument.builder().token(typeName.className());
        typeName.upperBounds().forEach(it -> builder.bound((TypeName)it).lowerBound(false));
        typeName.lowerBounds().forEach(it -> builder.bound((TypeName)it).lowerBound(true));
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public TypeName boxed() {
        return this;
    }

    @Override
    public TypeName genericTypeName() {
        if (this.bounds.isEmpty()) {
            return this;
        }
        return ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from((TypeName)this)).typeArguments(List.of())).typeParameters(List.of())).build();
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        writer.write(this.token.className());
        if (this.bounds.isEmpty()) {
            return;
        }
        if (this.isLowerBound) {
            writer.write(" super ");
        } else {
            writer.write(" extends ");
        }
        if (this.bounds.size() == 1) {
            this.bounds.getFirst().writeComponent(writer, declaredTokens, imports, classType);
            return;
        }
        for (int i = 0; i < this.bounds.size(); ++i) {
            if (i != 0) {
                writer.write(" & ");
            }
            this.bounds.get(i).writeComponent(writer, declaredTokens, imports, classType);
        }
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        for (Type bound : this.bounds) {
            bound.addImports(imports);
        }
    }

    public String token() {
        return this.token.className();
    }

    @Override
    public String packageName() {
        return "";
    }

    List<String> description() {
        return this.description;
    }

    @Override
    String fqTypeName() {
        return this.token.className();
    }

    @Override
    String resolvedTypeName() {
        return this.token.resolvedName();
    }

    @Override
    String simpleTypeName() {
        return this.token.className();
    }

    @Override
    boolean isArray() {
        return false;
    }

    @Override
    boolean innerClass() {
        return false;
    }

    @Override
    Optional<Type> declaringClass() {
        return Optional.empty();
    }

    public String className() {
        return this.token.className();
    }

    public List<String> enclosingNames() {
        return List.of();
    }

    public boolean primitive() {
        return false;
    }

    public boolean array() {
        return this.token.array();
    }

    public boolean generic() {
        return this.token.generic();
    }

    public boolean wildcard() {
        return this.token.wildcard();
    }

    public List<TypeName> typeArguments() {
        return List.of();
    }

    public List<String> typeParameters() {
        return List.of();
    }

    public List<TypeName> lowerBounds() {
        return List.of();
    }

    public List<TypeName> upperBounds() {
        return this.bounds.stream().map(Type::typeName).collect(Collectors.toUnmodifiableList());
    }

    public Optional<TypeName> componentType() {
        return Optional.empty();
    }

    public String toString() {
        if (this.bounds.isEmpty()) {
            return "Token: " + this.token.className();
        }
        return "Token: " + this.token.className() + " Bound: " + String.valueOf(this.bounds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeArgument typeArgument1 = (TypeArgument)o;
        return Objects.equals(this.token, typeArgument1.token) && Objects.equals(this.bounds, typeArgument1.bounds);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.bounds);
    }

    public int compareTo(TypeName o) {
        return this.token.compareTo(o);
    }

    @Override
    TypeName typeName() {
        return this;
    }

    public boolean vararg() {
        return false;
    }

    public List<Annotation> annotations() {
        return List.of();
    }

    public List<Annotation> inheritedAnnotations() {
        return List.of();
    }

    public static final class Builder
    extends ModelComponent.Builder<Builder, TypeArgument> {
        private final TypeName.Builder tokenBuilder = (TypeName.Builder)TypeName.builder().generic(true);
        private final List<Type> bounds = new ArrayList<Type>();
        private boolean isLowerBound;
        private List<String> description = List.of();

        private Builder() {
        }

        public Builder token(String token) {
            ((TypeName.Builder)this.tokenBuilder.className(Objects.requireNonNull(token))).wildcard(token.startsWith("?"));
            return this;
        }

        public Builder bound(String bound) {
            return this.bound(TypeName.create((String)bound));
        }

        public Builder bound(Class<?> bound) {
            return this.bound(TypeName.create(bound));
        }

        public Builder lowerBound(boolean lowerBound) {
            this.isLowerBound = lowerBound;
            return this;
        }

        public Builder bound(TypeName bound) {
            this.bounds.add(Type.fromTypeName(bound));
            return this;
        }

        public Builder addBound(TypeName bound) {
            this.bounds.add(Type.fromTypeName(bound));
            return this;
        }

        public Builder description(String description) {
            this.description = List.of(description.split("\n"));
            return this;
        }

        public Builder description(List<String> description) {
            this.description = List.copyOf(description);
            return this;
        }

        public TypeArgument build() {
            if (this.tokenBuilder.className().isEmpty()) {
                throw new ClassModelException("Token name needs to be specified.");
            }
            return new TypeArgument(this);
        }
    }
}

