/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

class ModelWriter
extends Writer {
    private final Writer delegate;
    private final String padding;
    private String currentPadding = "";
    private int paddingLevel = 0;
    private boolean firstWrite = true;

    ModelWriter(Writer delegate, String padding) {
        this.delegate = delegate;
        this.padding = padding;
    }

    void increasePaddingLevel() {
        ++this.paddingLevel;
        this.currentPadding = this.padding.repeat(this.paddingLevel);
    }

    void decreasePaddingLevel() {
        --this.paddingLevel;
        this.currentPadding = this.padding.repeat(this.paddingLevel);
    }

    void writeLine(String str) {
        this.write(str);
        this.write("\n");
    }

    void writeSeparatorLine() {
        try {
            this.delegate.write("\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(String str) {
        try {
            if (this.firstWrite) {
                this.delegate.write(this.currentPadding);
                this.firstWrite = false;
            }
            String padded = str.replaceAll("\n", "\n" + this.currentPadding);
            padded = padded.replaceAll("<<padding>>", this.padding);
            this.delegate.write(padded);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        try {
            this.delegate.write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.delegate.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ModelWriter append(CharSequence csq) {
        try {
            this.delegate.append(csq);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }
}

