/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.Executable;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.Returns;
import io.helidon.codegen.classmodel.Type;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Method
extends Executable {
    private final Map<String, TypeArgument> declaredTokens;
    private final boolean isDefault;
    private final boolean isFinal;
    private final boolean isStatic;
    private final boolean isAbstract;

    private Method(Builder builder) {
        super(builder);
        this.isDefault = builder.isDefault;
        this.isFinal = builder.isFinal;
        this.isStatic = builder.isStatic;
        this.isAbstract = builder.isAbstract;
        this.declaredTokens = Collections.unmodifiableMap(new LinkedHashMap<String, TypeArgument>(builder.declaredTokens));
    }

    public static Builder builder() {
        return new Builder().returnType(builder -> builder.type((Class)Void.TYPE));
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        if (this.javadoc().generate()) {
            this.javadoc().writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        for (Annotation annotation : this.annotations()) {
            annotation.writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        if (classType == ElementKind.INTERFACE) {
            if (this.isDefault) {
                writer.write("default ");
            } else if (this.isStatic) {
                writer.write("static ");
            }
        } else {
            if (AccessModifier.PACKAGE_PRIVATE != this.accessModifier()) {
                writer.write(this.accessModifier().modifierName() + " ");
            }
            if (this.isStatic) {
                writer.write("static ");
            }
            if (this.isFinal) {
                writer.write("final ");
            }
            if (this.isAbstract) {
                writer.write("abstract ");
            }
        }
        this.appendTokenDeclaration(writer, declaredTokens, imports, classType);
        this.type().writeComponent(writer, declaredTokens, imports, classType);
        writer.write(" " + this.name() + "(");
        boolean first = true;
        for (Parameter parameter : this.parameters()) {
            if (first) {
                first = false;
            } else {
                writer.write(", ");
            }
            parameter.writeComponent(writer, declaredTokens, imports, classType);
        }
        writer.write(")");
        this.writeThrows(writer, declaredTokens, imports, classType);
        if (classType == ElementKind.INTERFACE) {
            if (!this.isDefault && !this.isStatic) {
                writer.write(";");
                return;
            }
        } else if (this.isAbstract) {
            writer.write(";");
            return;
        }
        writer.write(" {");
        if (this.hasBody()) {
            this.writeBody(writer, imports);
        } else {
            writer.write("\n");
        }
        writer.write("}");
    }

    private void appendTokenDeclaration(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        LinkedHashSet<Object> tokensToDeclare = new LinkedHashSet<Object>();
        if (this.isStatic) {
            for (Parameter parameter : this.parameters()) {
                TypeArgument typeArgument;
                Type type = parameter.type();
                if (!(type instanceof TypeArgument) || ((String)(tokenName = (typeArgument = (TypeArgument)type).token())).equals("?")) continue;
                tokensToDeclare.add(tokenName);
            }
        } else {
            for (Parameter parameter : this.parameters()) {
                TypeArgument typeArgument;
                tokenName = parameter.type();
                if (!(tokenName instanceof TypeArgument) || declaredTokens.contains(tokenName = (typeArgument = (TypeArgument)tokenName).token()) || ((String)tokenName).equals("?")) continue;
                tokensToDeclare.add(tokenName);
            }
        }
        if (!tokensToDeclare.isEmpty()) {
            writer.write("<");
            boolean first = true;
            for (String string : tokensToDeclare) {
                if (first) {
                    first = false;
                } else {
                    writer.write(", ");
                }
                if (this.declaredTokens.containsKey(string)) {
                    this.declaredTokens.get(string).writeComponent(writer, declaredTokens, imports, classType);
                    continue;
                }
                writer.write(string);
            }
            for (Map.Entry entry : this.declaredTokens.entrySet()) {
                if (tokensToDeclare.contains(entry.getKey())) continue;
                ((TypeArgument)entry.getValue()).writeComponent(writer, declaredTokens, imports, classType);
            }
            writer.write("> ");
        } else if (!this.declaredTokens.isEmpty()) {
            writer.write("<");
            boolean first = true;
            for (Map.Entry entry : this.declaredTokens.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(", ");
                }
                ((TypeArgument)entry.getValue()).writeComponent(writer, declaredTokens, imports, classType);
            }
            writer.write("> ");
        }
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.type().addImports(imports);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        return Objects.equals(this.type(), method.type()) && Objects.equals(this.name(), method.name()) && this.parameters().size() == method.parameters().size() && this.parameters().equals(method.parameters());
    }

    public int hashCode() {
        return Objects.hash(this.type(), this.name(), this.parameters());
    }

    public String toString() {
        return "Method{name=" + this.name() + ", isFinal=" + this.isFinal + ", isStatic=" + this.isStatic + ", isAbstract=" + this.isAbstract + ", returnType=" + this.type().fqTypeName() + "}";
    }

    public static final class Builder
    extends Executable.Builder<Builder, Method> {
        private final Map<String, TypeArgument> declaredTokens = new LinkedHashMap<String, TypeArgument>();
        private boolean isDefault = false;
        private boolean isFinal = false;
        private boolean isStatic = false;
        private boolean isAbstract = false;

        Builder() {
        }

        public Method build() {
            if (this.name() == null) {
                throw new ClassModelException("Method needs to have name specified");
            }
            if (this.isStatic && this.isAbstract) {
                throw new IllegalStateException("Method cannot be static and abstract at the same time");
            }
            if (this.isFinal && this.isAbstract) {
                throw new IllegalStateException("Method cannot be final and abstract at the same time");
            }
            return new Method(this);
        }

        @Override
        public Builder content(List<String> content) {
            this.declaredTokens.clear();
            return (Builder)super.content((List)content);
        }

        public Builder isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        public Builder isAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder returnType(TypeName type) {
            return (Builder)this.type(type);
        }

        public Builder returnType(TypeName type, String description) {
            return (Builder)((Builder)this.type(type)).returnJavadoc(description);
        }

        public Builder returnType(Consumer<Returns.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Returns.Builder builder = Returns.builder();
            consumer.accept(builder);
            return this.returnType((Supplier<Returns>)((Object)builder));
        }

        public Builder returnType(Supplier<Returns> supplier) {
            Objects.requireNonNull(supplier);
            return this.returnType(supplier.get());
        }

        public Builder returnType(Returns returnType) {
            return (Builder)((Builder)this.type(returnType.type())).returnJavadoc(returnType.description());
        }

        public Builder addGenericArgument(TypeArgument typeArgument) {
            this.declaredTokens.put(typeArgument.token(), typeArgument);
            this.addGenericToken(typeArgument.token(), typeArgument.description());
            return this;
        }

        public Builder from(TypedElementInfo methodInfo) {
            ((Builder)((Builder)((Builder)((Builder)this.name(methodInfo.elementName())).accessModifier(methodInfo.accessModifier())).returnType(methodInfo.typeName()).update(it -> methodInfo.typeParameters().forEach(typeParam -> it.addGenericArgument(TypeArgument.create(typeParam))))).update(it -> methodInfo.annotations().forEach(it::addAnnotation))).isDefault(methodInfo.elementModifiers().contains(Modifier.DEFAULT)).isFinal(methodInfo.elementModifiers().contains(Modifier.FINAL)).isAbstract(methodInfo.elementModifiers().contains(Modifier.ABSTRACT)).isStatic(methodInfo.elementModifiers().contains(Modifier.STATIC)).update(it -> this.addGeneratedMethodParams(methodInfo.parameterArguments(), (Builder)it));
            return this;
        }

        Type returnType() {
            return this.type();
        }

        private void addGeneratedMethodParams(List<TypedElementInfo> params, Builder method) {
            for (TypedElementInfo param : params) {
                method.addParameter((Parameter.Builder parameter) -> ((Parameter.Builder)parameter.vararg(param.typeName().vararg()).name(param.elementName())).type(param.typeName()).update(it -> param.annotations().forEach(it::addAnnotation)));
            }
        }
    }
}

