/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.AnnotatedComponent;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.Content;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Field
extends AnnotatedComponent {
    private final Content defaultValue;
    private final boolean isFinal;
    private final boolean isStatic;
    private final boolean isVolatile;

    private Field(Builder builder) {
        super(builder);
        this.defaultValue = builder.defaultValueBuilder.build();
        this.isFinal = builder.isFinal;
        this.isStatic = builder.isStatic;
        this.isVolatile = builder.isVolatile;
    }

    public static Builder builder() {
        return new Builder().accessModifier(AccessModifier.PRIVATE);
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        boolean isRecord;
        boolean bl = isRecord = classType == ElementKind.RECORD;
        if (!isRecord && this.javadoc().generate()) {
            this.javadoc().writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        for (Annotation annotation : this.annotations()) {
            annotation.writeComponent(writer, declaredTokens, imports, classType);
            if (isRecord) continue;
            writer.write("\n");
        }
        if (classType != ElementKind.INTERFACE && (!isRecord || this.isStatic())) {
            if (AccessModifier.PACKAGE_PRIVATE != this.accessModifier()) {
                writer.write(this.accessModifier().modifierName());
                writer.write(" ");
            }
            if (this.isStatic) {
                writer.write("static ");
            }
            if (this.isFinal) {
                writer.write("final ");
            }
            if (this.isVolatile) {
                writer.write("volatile ");
            }
        }
        this.type().writeComponent(writer, declaredTokens, imports, classType);
        writer.write(" ");
        writer.write(this.name());
        if (!isRecord || this.isStatic()) {
            if (this.defaultValue.hasBody()) {
                writer.write(" = ");
                this.defaultValue.writeBody(writer, imports);
                writer.write(";");
            } else {
                writer.write(";");
            }
        }
    }

    void writeEnumConstant(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        if (this.javadoc().generate()) {
            this.javadoc().writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        for (Annotation annotation : this.annotations()) {
            annotation.writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
            writer.write(this.name());
            writer.write(";");
        }
        writer.write(this.name());
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.type().addImports(imports);
        this.defaultValue.addImports(imports);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return this.name().equals(field.name()) && this.type().equals(field.type()) && this.isStatic == field.isStatic && this.isFinal == field.isFinal && this.accessModifier().equals((Object)field.accessModifier());
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.type(), this.isFinal, this.isStatic, this.accessModifier());
    }

    public String toString() {
        if (this.defaultValue.hasBody()) {
            return this.accessModifier().modifierName() + " " + this.type().fqTypeName() + " " + this.name() + " = " + String.valueOf(this.defaultValue);
        }
        return this.accessModifier().modifierName() + " " + this.type().fqTypeName() + " " + this.name();
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public static final class Builder
    extends AnnotatedComponent.Builder<Builder, Field>
    implements ContentBuilder<Builder> {
        private final Content.Builder defaultValueBuilder = Content.builder();
        private boolean isFinal = false;
        private boolean isVolatile = false;
        private boolean isStatic = false;

        private Builder() {
        }

        public Field build() {
            return new Field(this);
        }

        public Builder defaultValue(String defaultValue) {
            if (defaultValue != null && this.type().equals(TypeNames.STRING) && !this.type().isArray() && !defaultValue.startsWith("\"") && !defaultValue.endsWith("\"")) {
                this.defaultValueBuilder.content("\"" + defaultValue + "\"");
            } else {
                this.defaultValueBuilder.content(defaultValue);
            }
            return this;
        }

        public Builder defaultValueContent(String defaultValue) {
            this.defaultValueBuilder.content(defaultValue);
            return this;
        }

        @Override
        public Builder content(List<String> content) {
            this.defaultValueBuilder.content((List)content);
            return this;
        }

        @Override
        public Builder addContent(String line) {
            this.defaultValueBuilder.addContent(line);
            return this;
        }

        @Override
        public Builder addContent(TypeName typeName) {
            this.defaultValueBuilder.addContent(typeName);
            return this;
        }

        @Override
        public Builder padContent() {
            this.defaultValueBuilder.padContent();
            return this;
        }

        @Override
        public Builder padContent(int repetition) {
            this.defaultValueBuilder.padContent(repetition);
            return this;
        }

        @Override
        public Builder increaseContentPadding() {
            this.defaultValueBuilder.increaseContentPadding();
            return this;
        }

        @Override
        public Builder decreaseContentPadding() {
            this.defaultValueBuilder.decreaseContentPadding();
            return this;
        }

        @Override
        public Builder clearContent() {
            this.defaultValueBuilder.clearContent();
            return this;
        }

        @Override
        public Builder addTypeToContent(String typeName) {
            this.defaultValueBuilder.addTypeToContent(typeName);
            return this;
        }

        public Builder isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder isVolatile(boolean isVolatile) {
            this.isVolatile = isVolatile;
            return this;
        }

        public Builder isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        @Override
        public Builder type(TypeName type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(String type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(Class<?> type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder accessModifier(AccessModifier accessModifier) {
            return (Builder)super.accessModifier(accessModifier);
        }

        @Override
        public Builder javadoc(Javadoc javadoc) {
            return (Builder)super.javadoc(javadoc);
        }
    }
}

