/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.ModelComponent;
import io.helidon.codegen.classmodel.Type;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract class DescribableComponent
extends ModelComponent {
    private final Type type;
    private final List<String> description;

    DescribableComponent(Builder<?, ?> builder) {
        super(builder);
        this.type = builder.type;
        this.description = builder.description;
    }

    Type type() {
        return this.type;
    }

    public List<String> description() {
        return this.description;
    }

    public TypeName typeName() {
        return this.type().typeName();
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        if (this.includeImport() && this.type != null) {
            this.type.addImports(imports);
        }
    }

    static abstract class Builder<B extends Builder<B, T>, T extends DescribableComponent>
    extends ModelComponent.Builder<B, T> {
        private final List<String> description = new ArrayList<String>();
        private Type type;

        Builder() {
        }

        B type(String type) {
            Objects.requireNonNull(type);
            return this.type(TypeName.create((String)type));
        }

        B type(Class<?> type) {
            Objects.requireNonNull(type);
            return this.type(TypeName.create(type));
        }

        B type(TypeName type) {
            Objects.requireNonNull(type);
            return this.type(Type.fromTypeName(type));
        }

        B type(Type type) {
            Objects.requireNonNull(type);
            this.type = type;
            return (B)((Builder)this.identity());
        }

        B description(String description) {
            Objects.requireNonNull(description);
            this.description.clear();
            this.description.add(description);
            return (B)((Builder)this.identity());
        }

        B description(List<String> description) {
            Objects.requireNonNull(description);
            this.description.clear();
            this.description.addAll(description);
            return (B)((Builder)this.identity());
        }

        Type type() {
            return this.type;
        }
    }
}

