/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Type;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Content {
    private final StringBuilder content;
    private final Set<String> toImport;
    private final List<Position> tokenPositions;

    private Content(Builder builder) {
        this.content = new StringBuilder(builder.content);
        this.toImport = Set.copyOf(builder.toImport);
        this.tokenPositions = List.copyOf(builder.tokenPositions);
    }

    static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.content.toString();
    }

    boolean hasBody() {
        return !this.content.isEmpty();
    }

    void writeBody(ModelWriter writer, ImportOrganizer imports) {
        int offset = 0;
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Position position : this.tokenPositions) {
            String replacement = replacements.computeIfAbsent(position.type, key -> {
                TypeName typeName = TypeName.create((String)key);
                return imports.typeName(Type.fromTypeName(typeName), true);
            });
            this.content.replace(position.start - offset, position.end - offset, replacement);
            offset += position.end - position.start - replacement.length();
        }
        String[] lines = this.content.toString().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            writer.write(line);
            if (i + 1 == lines.length) continue;
            writer.write("\n");
        }
    }

    void addImports(ImportOrganizer.Builder builder) {
        this.toImport.forEach(builder::addImport);
    }

    static final class Builder
    implements ContentBuilder<Builder>,
    io.helidon.common.Builder<Builder, Content> {
        private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("@([.a-zA-Z0-9_]+)@");
        private static final Pattern TYPE_IDENTIFICATION_PATTERN = Pattern.compile("[.a-zA-Z0-9_]+");
        private final StringBuilder content = new StringBuilder();
        private final Set<String> toImport = new HashSet<String>();
        private final List<Position> tokenPositions = new ArrayList<Position>();
        private String extraPadding = "";
        private int extraPaddingLevel = 0;
        private boolean newLine = false;

        private Builder() {
        }

        public Content build() {
            this.toImport.clear();
            this.tokenPositions.clear();
            this.identifyClassTokens();
            return new Content(this);
        }

        @Override
        public Builder content(List<String> content) {
            this.content.setLength(0);
            content.forEach(this::addContentLine);
            return this;
        }

        @Override
        public Builder addContent(String line) {
            String trimmed = line.trim();
            if (trimmed.equals("}")) {
                this.decreaseContentPadding();
            }
            if (this.newLine) {
                this.content.append(this.extraPadding);
            }
            this.newLine = line.endsWith("\n");
            Object replacedLine = this.newLine ? line.substring(0, line.lastIndexOf("\n")).replaceAll("\n", "\n" + this.extraPadding) + "\n" : line.replaceAll("\n", "\n" + this.extraPadding);
            this.content.append((String)replacedLine);
            if (trimmed.endsWith("{")) {
                this.increaseContentPadding();
            }
            return this;
        }

        @Override
        public Builder padContent() {
            this.content.append("<<padding>>");
            return (Builder)this.identity();
        }

        @Override
        public Builder padContent(int repetition) {
            this.content.append("<<padding>>".repeat(repetition));
            return (Builder)this.identity();
        }

        @Override
        public Builder addTypeToContent(String typeName) {
            String processedFqName = TYPE_IDENTIFICATION_PATTERN.matcher(typeName).replaceAll(className -> "@name@".replace("name", className.group()));
            return this.addContent(processedFqName);
        }

        @Override
        public Builder increaseContentPadding() {
            ++this.extraPaddingLevel;
            this.extraPadding = "<<padding>>".repeat(this.extraPaddingLevel);
            return (Builder)this.identity();
        }

        @Override
        public Builder decreaseContentPadding() {
            --this.extraPaddingLevel;
            if (this.extraPaddingLevel < 0) {
                throw new ClassModelException("Content padding cannot be negative");
            }
            this.extraPadding = "<<padding>>".repeat(this.extraPaddingLevel);
            return (Builder)this.identity();
        }

        @Override
        public Builder clearContent() {
            this.content.setLength(0);
            return (Builder)this.identity();
        }

        private void identifyClassTokens() {
            Matcher matcher = TYPE_NAME_PATTERN.matcher(this.content);
            while (matcher.find()) {
                String className = matcher.group(1);
                this.toImport.add(className);
                this.tokenPositions.add(new Position(matcher.start(), matcher.end(), className));
            }
        }
    }

    private record Position(int start, int end, String type) {
    }
}

