/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.CommonComponent;
import io.helidon.codegen.classmodel.ImportOrganizer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

abstract class AnnotatedComponent
extends CommonComponent {
    private final List<Annotation> annotations;

    AnnotatedComponent(Builder<?, ?> builder) {
        super((CommonComponent.Builder<?, ?>)builder);
        this.annotations = List.copyOf(builder.annotations);
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.annotations.forEach(annotation -> annotation.addImports(imports));
    }

    public List<Annotation> annotations() {
        return List.copyOf(this.annotations);
    }

    static abstract class Builder<B extends Builder<B, T>, T extends AnnotatedComponent>
    extends CommonComponent.Builder<B, T> {
        private final List<Annotation> annotations = new ArrayList<Annotation>();

        Builder() {
        }

        @Override
        public B description(String description) {
            return (B)((Builder)super.description(description));
        }

        @Override
        public B description(List<String> description) {
            return (B)((Builder)super.description((List)description));
        }

        @Override
        public B addDescriptionLine(String line) {
            return (B)((Builder)super.addDescriptionLine(line));
        }

        public B addAnnotation(io.helidon.common.types.Annotation annotation) {
            return this.addAnnotation(Annotation.create(annotation));
        }

        public B addAnnotation(Consumer<Annotation.Builder> consumer) {
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            return this.addAnnotation(builder.build());
        }

        public B addAnnotation(Annotation.Builder builder) {
            return this.addAnnotation(builder.build());
        }

        public B addAnnotation(Annotation annotation) {
            this.annotations.add(annotation);
            return (B)((Builder)this.identity());
        }

        @Override
        public B name(String name) {
            return (B)((Builder)super.name(name));
        }
    }
}

