/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.ClassType;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.ModelComponent;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Type;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class ConcreteType
extends Type {
    private final TypeName typeName;
    private final Type declaringType;
    private final List<Type> typeParams;

    ConcreteType(Builder builder) {
        super(builder);
        this.typeName = builder.typeName;
        if (this.typeName.enclosingNames().isEmpty()) {
            this.declaringType = null;
        } else {
            String parents = String.join((CharSequence)".", this.typeName.enclosingNames());
            TypeName parent = this.typeName.packageName().isEmpty() ? TypeName.create((String)parents) : TypeName.create((String)(this.typeName.packageName() + "." + parents));
            this.declaringType = Type.fromTypeName(parent);
        }
        this.typeParams = List.copyOf(builder.typeParams);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        String typeName = imports.typeName(this, this.includeImport());
        writer.write(typeName);
        if (!this.typeParams.isEmpty()) {
            writer.write("<");
            boolean first = true;
            for (Type parameter : this.typeParams) {
                if (first) {
                    first = false;
                } else {
                    writer.write(", ");
                }
                parameter.writeComponent(writer, declaredTokens, imports, classType);
            }
            writer.write(">");
        }
        if (this.isArray()) {
            writer.write("[]");
        }
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        if (this.includeImport()) {
            imports.addImport(this);
        }
        this.typeParams.forEach(type -> type.addImports(imports));
    }

    @Override
    String fqTypeName() {
        if (this.innerClass()) {
            return this.typeName.classNameWithEnclosingNames();
        }
        return this.typeName.name();
    }

    @Override
    String resolvedTypeName() {
        return this.typeName.resolvedName();
    }

    @Override
    String simpleTypeName() {
        return this.typeName.className();
    }

    @Override
    boolean isArray() {
        return this.typeName.array();
    }

    @Override
    boolean innerClass() {
        return !this.typeName.enclosingNames().isEmpty();
    }

    @Override
    Optional<Type> declaringClass() {
        return Optional.ofNullable(this.declaringType);
    }

    @Override
    TypeName genericTypeName() {
        return this.typeName;
    }

    @Override
    String packageName() {
        return this.typeName.packageName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcreteType that = (ConcreteType)o;
        return this.isArray() == that.isArray() && Objects.equals(this.typeName.resolvedName(), that.typeName.resolvedName());
    }

    public String toString() {
        return this.typeName.toString();
    }

    public int hashCode() {
        return Objects.hash(this.isArray(), this.typeName.resolvedName());
    }

    @Override
    TypeName typeName() {
        return this.typeName;
    }

    static final class Builder
    extends ModelComponent.Builder<Builder, ConcreteType> {
        private final List<Type> typeParams = new ArrayList<Type>();
        private TypeName typeName;

        private Builder() {
        }

        public ConcreteType build() {
            if (this.typeName == null) {
                throw new ClassModelException("Type value needs to be set");
            }
            return new ConcreteType(this);
        }

        Builder type(String typeName) {
            return this.type(TypeName.create((String)typeName));
        }

        Builder type(Class<?> typeName) {
            return this.type(TypeName.create(typeName));
        }

        Builder type(TypeName typeName) {
            this.typeName = typeName;
            return this;
        }

        Builder addParam(TypeName typeName) {
            this.typeParams.add(Type.fromTypeName(typeName));
            return this;
        }
    }
}

