/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.ClassType;
import io.helidon.codegen.classmodel.CommonComponent;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Type;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.EnumValue;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class AnnotationParameter
extends CommonComponent {
    private final Set<TypeName> importedTypes;
    private final Object objectValue;

    private AnnotationParameter(Builder builder) {
        super(builder);
        this.objectValue = builder.value;
        this.importedTypes = AnnotationParameter.resolveImports(builder.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.valueOf(this.objectValue) + " (" + this.type().simpleTypeName() + ")";
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        writer.write(this.name() + " = ");
        this.writeValue(writer, imports);
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        this.importedTypes.forEach(imports::addImport);
    }

    void writeValue(ModelWriter writer, ImportOrganizer imports) throws IOException {
        writer.write(AnnotationParameter.resolveValueToString(imports, this.type(), this.objectValue));
    }

    private static Set<TypeName> resolveImports(Object value) {
        HashSet<TypeName> imports = new HashSet<TypeName>();
        AnnotationParameter.resolveImports(imports, value);
        return imports;
    }

    private static void resolveImports(Set<TypeName> imports, Object value) {
        if (value.getClass().isEnum()) {
            imports.add(TypeName.create(value.getClass()));
            return;
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeName.class, EnumValue.class, Annotation.class}, (Object)object2, n)) {
            case 0: {
                TypeName tn = (TypeName)object2;
                imports.add(tn);
                break;
            }
            case 1: {
                EnumValue ev = (EnumValue)object2;
                imports.add(ev.type());
                break;
            }
            case 2: {
                Annotation an = (Annotation)object2;
                imports.add(an.typeName());
                an.values().values().forEach(nestedValue -> AnnotationParameter.resolveImports(imports, nestedValue));
                break;
            }
        }
    }

    private static String resolveValueToString(ImportOrganizer imports, Type type, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass.isEnum()) {
            return imports.typeName(Type.fromTypeName(TypeName.create(valueClass)), true) + "." + ((Enum)value).name();
        }
        if (type != null && type.fqTypeName().equals(String.class.getName())) {
            String stringValue = value.toString();
            if (!stringValue.startsWith("\"") && !stringValue.endsWith("\"")) {
                return "\"" + stringValue + "\"";
            }
            return stringValue;
        }
        if (type != null && type.fqTypeName().equals(Object.class.getName())) {
            return value.toString();
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeName.class, EnumValue.class, Character.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Class.class, Annotation.class, List.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                TypeName typeName = (TypeName)object2;
                yield imports.typeName(Type.fromTypeName(typeName), true) + ".class";
            }
            case 1 -> {
                EnumValue enumValue = (EnumValue)object2;
                yield imports.typeName(Type.fromTypeName(enumValue.type()), true) + "." + enumValue.name();
            }
            case 2 -> {
                Character character = (Character)object2;
                yield "'" + character + "'";
            }
            case 3 -> {
                Long longValue = (Long)object2;
                yield longValue + "L";
            }
            case 4 -> {
                Float floatValue = (Float)object2;
                yield floatValue + "F";
            }
            case 5 -> {
                Double doubleValue = (Double)object2;
                yield doubleValue + "D";
            }
            case 6 -> {
                Byte byteValue = (Byte)object2;
                yield "(byte) " + byteValue;
            }
            case 7 -> {
                Short shortValue = (Short)object2;
                yield "(short) " + shortValue;
            }
            case 8 -> {
                Class clazz = (Class)object2;
                yield imports.typeName(Type.fromTypeName(TypeName.create((java.lang.reflect.Type)clazz)), true) + ".class";
            }
            case 9 -> {
                Annotation annotation = (Annotation)object2;
                yield AnnotationParameter.nestedAnnotationValue(imports, annotation);
            }
            case 10 -> {
                List list = (List)object2;
                yield AnnotationParameter.nestedListValue(imports, list);
            }
            case 11 -> {
                String str = (String)object2;
                if (str.startsWith("\"") && str.endsWith("\"")) {
                    yield str;
                }
                yield "\"" + str + "\"";
            }
            default -> value.toString();
        };
    }

    private static String nestedListValue(ImportOrganizer imports, List<?> list) {
        if (list.isEmpty()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        if (list.size() > 1) {
            result.append("{");
        }
        result.append(list.stream().map(it -> AnnotationParameter.resolveValueToString(imports, null, it)).collect(Collectors.joining(", ")));
        if (list.size() > 1) {
            result.append("}");
        }
        return result.toString();
    }

    private static String nestedAnnotationValue(ImportOrganizer imports, Annotation annotation) {
        StringBuilder sb = new StringBuilder("@");
        sb.append(imports.typeName(Type.fromTypeName(annotation.typeName()), true));
        Map values = annotation.values();
        if (values.isEmpty()) {
            return sb.toString();
        }
        sb.append("(");
        if (values.size() == 1 && values.containsKey("value")) {
            sb.append(AnnotationParameter.resolveValueToString(imports, null, values.get("value")));
        } else {
            values.forEach((key, value) -> sb.append((String)key).append(" = ").append(AnnotationParameter.resolveValueToString(imports, null, value)).append(", "));
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    public static final class Builder
    extends CommonComponent.Builder<Builder, AnnotationParameter> {
        private Object value;

        private Builder() {
        }

        public AnnotationParameter build() {
            if (this.value == null || this.name() == null) {
                throw new ClassModelException("Annotation parameter needs to have value and type set");
            }
            return new AnnotationParameter(this);
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        public Builder value(Object value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        @Override
        public Builder type(TypeName type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(String type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(Class<?> type) {
            return (Builder)super.type(type);
        }
    }
}

