/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.TypeInfoFactoryBase;
import io.helidon.codegen.apt.AptAnnotationFactory;
import io.helidon.codegen.apt.AptContext;
import io.helidon.codegen.apt.AptTypeFactory;
import io.helidon.codegen.apt.ToAnnotationValueVisitor;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

@Deprecated(forRemoval=true)
public final class AptTypeInfoFactory
extends TypeInfoFactoryBase {
    private static final Map<TypeName, List<Annotation>> META_ANNOTATION_CACHE = new ConcurrentHashMap<TypeName, List<Annotation>>();

    private AptTypeInfoFactory() {
    }

    public static Optional<TypeInfo> create(AptContext ctx, TypeName typeName) {
        return AptTypeInfoFactory.create(ctx, typeName, (Predicate<TypedElementInfo>)ElementInfoPredicates.ALL_PREDICATE);
    }

    public static Optional<TypeInfo> create(AptContext ctx, TypeName typeName, Predicate<TypedElementInfo> elementPredicate) throws IllegalArgumentException {
        TypeElement typeElement = ctx.aptEnv().getElementUtils().getTypeElement(typeName.fqName());
        if (typeElement == null) {
            return Optional.empty();
        }
        return AptTypeFactory.createTypeName(typeElement.asType()).flatMap(it -> AptTypeInfoFactory.create(ctx, typeElement, elementPredicate, it)).flatMap(it -> AptTypeInfoFactory.mapType((CodegenContext)ctx, (TypeInfo)it));
    }

    @Deprecated(forRemoval=true)
    public static Optional<TypeInfo> create(AptContext ctx, TypeElement typeElement) {
        TypeName typeName = AptTypeFactory.createTypeName(typeElement.asType()).orElse(null);
        if (typeName == null) {
            return Optional.empty();
        }
        return AptTypeInfoFactory.create(ctx, typeName);
    }

    public static Optional<TypeInfo> create(AptContext ctx, TypeElement typeElement, Predicate<TypedElementInfo> elementPredicate) throws IllegalArgumentException {
        return AptTypeFactory.createTypeName(typeElement.asType()).flatMap(it -> AptTypeInfoFactory.create(ctx, typeElement, elementPredicate, it));
    }

    public static Optional<TypedElementInfo> createTypedElementInfoFromElement(AptContext ctx, TypeName processedType, Element v, Elements elements) {
        return AptTypeInfoFactory.createTypedElementInfoFromElement(ctx, processedType, v, elements, false);
    }

    public static Optional<TypedElementInfo> createTypedElementInfoFromElement(AptContext ctx, TypeName processedType, Element v, Elements elements, boolean varargType) {
        String javadoc;
        TypeName type = AptTypeFactory.createTypeName(v).orElse(null);
        TypeMirror typeMirror = null;
        String defaultValue = null;
        List<TypedElementInfo> params = List.of();
        List<Object> componentTypeNames = List.of();
        List<Object> elementTypeAnnotations = List.of();
        Set<String> modifierNames = v.getModifiers().stream().map(Modifier::toString).collect(Collectors.toSet());
        Set<Object> thrownChecked = Set.of();
        ArrayList typeParameters = new ArrayList();
        if (v instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)v;
            boolean isVararg = ee.isVarArgs();
            typeMirror = Objects.requireNonNull(ee.getReturnType());
            int paramCount = ee.getParameters().size();
            if (paramCount > 0) {
                params = new ArrayList();
            }
            for (int i = 0; i < paramCount; ++i) {
                VariableElement variableElement = ee.getParameters().get(i);
                boolean varargParam = isVararg && i == paramCount - 1;
                TypedElementInfo parameter = AptTypeInfoFactory.createTypedElementInfoFromElement(ctx, processedType, variableElement, elements, varargParam).orElseThrow(() -> new CodegenException("Failed to create element info for parameter: " + String.valueOf(variableElement) + ", either it uses invalid type, or it was removed by an element mapper. This would result in an invalid TypeInfo model.", (Object)variableElement));
                params.add(parameter);
            }
            AnnotationValue annotationValue = ee.getDefaultValue();
            defaultValue = annotationValue == null ? null : String.valueOf(annotationValue.accept(new ToAnnotationValueVisitor(elements).mapBooleanToNull(true).mapVoidToNull(true).mapBlankArrayToNull(true).mapEmptyStringToNull(true).mapToSourceDeclaration(true), null));
            thrownChecked = ee.getThrownTypes().stream().filter(it -> AptTypeInfoFactory.isCheckedException(ctx, it)).flatMap(it -> AptTypeFactory.createTypeName(it).stream()).collect(Collectors.toSet());
            List<? extends TypeParameterElement> elementTypeParameters = ee.getTypeParameters();
            if (!elementTypeParameters.isEmpty()) {
                elementTypeParameters.stream().map(AptTypeFactory::createTypeName).flatMap(it -> it.isPresent() ? it.stream() : Stream.of(TypeName.createFromGenericDeclaration((String)"error"))).forEach(typeParameters::add);
            }
        } else if (v instanceof VariableElement) {
            VariableElement ve = (VariableElement)v;
            typeMirror = Objects.requireNonNull(ve.asType());
            Object variableDefault = ve.getConstantValue();
            if (variableDefault != null) {
                defaultValue = String.valueOf(variableDefault);
            }
        }
        if (typeMirror != null) {
            if (type == null) {
                Element element = ctx.aptEnv().getTypeUtils().asElement(typeMirror);
                if (element instanceof TypeElement) {
                    TypeElement typeElement = (TypeElement)element;
                    type = AptTypeFactory.createTypeName(typeElement, typeMirror).orElse(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
                } else {
                    type = AptTypeFactory.createTypeName(typeMirror).orElse(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
                }
            }
            if (typeMirror instanceof DeclaredType) {
                List<? extends TypeMirror> args = ((DeclaredType)typeMirror).getTypeArguments();
                componentTypeNames = args.stream().map(AptTypeFactory::createTypeName).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
                elementTypeAnnotations = AptTypeInfoFactory.createAnnotations(ctx, ((DeclaredType)typeMirror).asElement(), elements);
            }
        }
        if (type == null) {
            throw new CodegenException("Failed to create type for element: " + String.valueOf(v) + " in type " + processedType.fqName(), (Object)v);
        }
        if (type.array() && varargType) {
            type = ((TypeName.Builder)TypeName.builder((TypeName)type).vararg(true)).build();
        }
        javadoc = (javadoc = ctx.aptEnv().getElementUtils().getDocComment(v)) == null || javadoc.isBlank() ? "" : javadoc;
        List<Annotation> annotations = AptTypeInfoFactory.createAnnotations(ctx, v, elements);
        List<Annotation> inheritedAnnotations = AptTypeInfoFactory.createInheritedAnnotations(ctx, processedType.genericTypeName(), annotations);
        TypedElementInfo.Builder builder = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().description(javadoc)).typeName(type)).componentTypes(componentTypeNames)).elementName(v.getSimpleName().toString())).kind(AptTypeInfoFactory.kind(v.getKind()))).annotations(annotations)).elementTypeAnnotations(elementTypeAnnotations)).inheritedAnnotations(inheritedAnnotations)).elementModifiers(AptTypeInfoFactory.modifiers((CodegenContext)ctx, modifierNames))).accessModifier(AptTypeInfoFactory.accessModifier(modifierNames))).throwsChecked(thrownChecked)).parameterArguments(params)).typeParameters(typeParameters)).originatingElement((Object)v);
        Element enclosingElement = v.getEnclosingElement();
        if (enclosingElement != null) {
            AptTypeFactory.createTypeName(enclosingElement).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).enclosingType(arg_0));
        }
        Optional.ofNullable(defaultValue).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).defaultValue(arg_0));
        return AptTypeInfoFactory.mapElement((CodegenContext)ctx, (TypedElementInfo)builder.build());
    }

    @Deprecated(since="4.0.10", forRemoval=true)
    public static Optional<TypedElementInfo> createTypedElementInfoFromElement(AptContext ctx, Element v, Elements elements) {
        String javadoc;
        TypeName type = AptTypeFactory.createTypeName(v).orElse(null);
        TypeMirror typeMirror = null;
        String defaultValue = null;
        List<Object> params = List.of();
        List<Object> componentTypeNames = List.of();
        List<Object> elementTypeAnnotations = List.of();
        Set<String> modifierNames = v.getModifiers().stream().map(Modifier::toString).collect(Collectors.toSet());
        Set<Object> thrownChecked = Set.of();
        if (v instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)v;
            typeMirror = Objects.requireNonNull(ee.getReturnType());
            params = ee.getParameters().stream().map(it -> AptTypeInfoFactory.createTypedElementInfoFromElement(ctx, it, elements).orElseThrow(() -> new CodegenException("Failed to create element info for parameter: " + String.valueOf(it) + ", either it uses invalid type, or it was removed by an element mapper. This would result in an invalid TypeInfo model.", it))).toList();
            AnnotationValue annotationValue = ee.getDefaultValue();
            defaultValue = annotationValue == null ? null : String.valueOf(annotationValue.accept(new ToAnnotationValueVisitor(elements).mapBooleanToNull(true).mapVoidToNull(true).mapBlankArrayToNull(true).mapEmptyStringToNull(true).mapToSourceDeclaration(true), null));
            thrownChecked = ee.getThrownTypes().stream().filter(it -> AptTypeInfoFactory.isCheckedException(ctx, it)).flatMap(it -> AptTypeFactory.createTypeName(it).stream()).collect(Collectors.toSet());
        } else if (v instanceof VariableElement) {
            VariableElement ve = (VariableElement)v;
            typeMirror = Objects.requireNonNull(ve.asType());
        }
        if (typeMirror != null) {
            if (type == null) {
                Element element = ctx.aptEnv().getTypeUtils().asElement(typeMirror);
                if (element instanceof TypeElement) {
                    TypeElement typeElement = (TypeElement)element;
                    type = AptTypeFactory.createTypeName(typeElement, typeMirror).orElse(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
                } else {
                    type = AptTypeFactory.createTypeName(typeMirror).orElse(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
                }
            }
            if (typeMirror instanceof DeclaredType) {
                List<? extends TypeMirror> args = ((DeclaredType)typeMirror).getTypeArguments();
                componentTypeNames = args.stream().map(AptTypeFactory::createTypeName).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
                elementTypeAnnotations = AptTypeInfoFactory.createAnnotations(ctx, ((DeclaredType)typeMirror).asElement(), elements);
            }
        }
        javadoc = (javadoc = ctx.aptEnv().getElementUtils().getDocComment(v)) == null || javadoc.isBlank() ? "" : javadoc;
        TypedElementInfo.Builder builder = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().description(javadoc)).typeName(type)).componentTypes(componentTypeNames)).elementName(v.getSimpleName().toString())).kind(AptTypeInfoFactory.kind(v.getKind()))).annotations(AptTypeInfoFactory.createAnnotations(ctx, v, elements))).elementTypeAnnotations(elementTypeAnnotations)).elementModifiers(AptTypeInfoFactory.modifiers((CodegenContext)ctx, modifierNames))).accessModifier(AptTypeInfoFactory.accessModifier(modifierNames))).throwsChecked(thrownChecked)).parameterArguments(params)).originatingElement((Object)v);
        AptTypeFactory.createTypeName(v.getEnclosingElement()).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).enclosingType(arg_0));
        Optional.ofNullable(defaultValue).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).defaultValue(arg_0));
        return AptTypeInfoFactory.mapElement((CodegenContext)ctx, (TypedElementInfo)builder.build());
    }

    private static boolean isCheckedException(AptContext ctx, TypeMirror it) {
        ProcessingEnvironment aptEnv = ctx.aptEnv();
        Elements elements = aptEnv.getElementUtils();
        Types types = aptEnv.getTypeUtils();
        TypeMirror exception = elements.getTypeElement(Exception.class.getName()).asType();
        TypeMirror runtimeException = elements.getTypeElement(RuntimeException.class.getName()).asType();
        return types.isAssignable(it, exception) && !types.isAssignable(it, runtimeException);
    }

    private static io.helidon.common.types.ElementKind kind(ElementKind kind) {
        try {
            return io.helidon.common.types.ElementKind.valueOf((String)String.valueOf((Object)kind).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ignored) {
            return io.helidon.common.types.ElementKind.OTHER;
        }
    }

    private static Optional<TypeInfo> create(AptContext ctx, TypeElement typeElement, Predicate<TypedElementInfo> elementPredicate, TypeName typeName) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(typeElement);
        Objects.requireNonNull(elementPredicate);
        Objects.requireNonNull(typeName);
        if (typeName.resolvedName().equals(Object.class.getName())) {
            return Optional.empty();
        }
        if (elementPredicate == ElementInfoPredicates.ALL_PREDICATE) {
            return ctx.cache(typeName, () -> AptTypeInfoFactory.createUncached(ctx, typeElement, elementPredicate, typeName));
        }
        return AptTypeInfoFactory.createUncached(ctx, typeElement, elementPredicate, typeName);
    }

    private static Optional<TypeInfo> createUncached(AptContext ctx, TypeElement typeElement, Predicate<TypedElementInfo> elementPredicate, TypeName typeName) {
        TypeName genericTypeName = typeName.genericTypeName();
        LinkedHashSet<TypeName> allInterestingTypeNames = new LinkedHashSet<TypeName>();
        allInterestingTypeNames.add(genericTypeName);
        typeName.typeArguments().stream().map(TypeName::genericTypeName).filter(Predicate.not(x$0 -> AptTypeInfoFactory.isBuiltInJavaType((TypeName)x$0))).filter(Predicate.not(rec$ -> ((TypeName)rec$).generic())).forEach(allInterestingTypeNames::add);
        Elements elementUtils = ctx.aptEnv().getElementUtils();
        try {
            TypeName fqSuperTypeName;
            TypeElement foundType = elementUtils.getTypeElement(genericTypeName.resolvedName());
            if (foundType == null) {
                return Optional.empty();
            }
            TypeName declaredTypeName = AptTypeInfoFactory.declaredTypeName(ctx, genericTypeName);
            List<Annotation> annotations = AptTypeInfoFactory.createAnnotations(ctx, foundType, elementUtils);
            List<Annotation> inheritedAnnotations = AptTypeInfoFactory.createInheritedAnnotations(ctx, genericTypeName, annotations);
            HashSet<TypeName> annotationsOnTypeOrElements = new HashSet<TypeName>();
            annotations.stream().map(rec$ -> ((Annotation)rec$).typeName()).forEach(annotationsOnTypeOrElements::add);
            ArrayList elementsWeCareAbout = new ArrayList();
            ArrayList otherElements = new ArrayList();
            typeElement.getEnclosedElements().stream().flatMap(it -> AptTypeInfoFactory.createTypedElementInfoFromElement(ctx, genericTypeName, it, elementUtils).stream()).forEach(it -> AptTypeInfoFactory.collectEnclosedElements(elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements, it));
            Set<String> modifiers = AptTypeInfoFactory.toModifierNames(typeElement.getModifiers());
            TypeInfo.Builder builder = (TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)TypeInfo.builder().originatingElement((Object)typeElement)).typeName(typeName)).rawType(genericTypeName)).declaredType(declaredTypeName)).kind(AptTypeInfoFactory.kind(typeElement.getKind()))).annotations(annotations)).inheritedAnnotations(inheritedAnnotations)).elementModifiers(AptTypeInfoFactory.modifiers((CodegenContext)ctx, modifiers))).accessModifier(AptTypeInfoFactory.accessModifier(modifiers))).elementInfo(elementsWeCareAbout)).otherElementInfo(otherElements);
            String javadoc = elementUtils.getDocComment(typeElement);
            if (javadoc != null) {
                builder.description(javadoc);
            }
            elementsWeCareAbout.forEach(it -> {
                if (!AptTypeInfoFactory.isBuiltInJavaType((TypeName)it.typeName()) && !it.typeName().generic()) {
                    allInterestingTypeNames.add(it.typeName().genericTypeName());
                }
                it.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).map(TypeName::genericTypeName).filter(t -> !AptTypeInfoFactory.isBuiltInJavaType((TypeName)t)).filter(t -> !t.generic()).forEach(allInterestingTypeNames::add);
            });
            TypeMirror superTypeMirror = typeElement.getSuperclass();
            TypeElement superTypeElement = (TypeElement)ctx.aptEnv().getTypeUtils().asElement(superTypeMirror);
            if (superTypeElement != null && (fqSuperTypeName = (TypeName)AptTypeFactory.createTypeName(superTypeElement, superTypeMirror).orElse(null)) != null && !TypeNames.OBJECT.equals((Object)fqSuperTypeName)) {
                TypeName genericSuperTypeName = fqSuperTypeName.genericTypeName();
                Optional<TypeInfo> superTypeInfo = AptTypeInfoFactory.create(ctx, superTypeElement, elementPredicate, fqSuperTypeName);
                superTypeInfo.ifPresent(arg_0 -> ((TypeInfo.Builder)builder).superTypeInfo(arg_0));
                allInterestingTypeNames.add(genericSuperTypeName);
                fqSuperTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !AptTypeInfoFactory.isBuiltInJavaType((TypeName)it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
            }
            typeElement.getInterfaces().forEach(interfaceTypeMirror -> {
                TypeName fqInterfaceTypeName = AptTypeFactory.createTypeName(interfaceTypeMirror).orElse(null);
                if (fqInterfaceTypeName != null) {
                    TypeName genericInterfaceTypeName = fqInterfaceTypeName.genericTypeName();
                    allInterestingTypeNames.add(genericInterfaceTypeName);
                    fqInterfaceTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !AptTypeInfoFactory.isBuiltInJavaType((TypeName)it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
                    TypeElement interfaceTypeElement = elementUtils.getTypeElement(fqInterfaceTypeName.genericTypeName().resolvedName());
                    if (interfaceTypeElement != null) {
                        Optional<TypeInfo> superTypeInfo = AptTypeInfoFactory.create(ctx, interfaceTypeElement, elementPredicate, fqInterfaceTypeName);
                        superTypeInfo.ifPresent(arg_0 -> ((TypeInfo.Builder)builder).addInterfaceTypeInfo(arg_0));
                    }
                }
            });
            AtomicReference moduleName = new AtomicReference();
            allInterestingTypeNames.forEach(it -> {
                TypeElement theTypeElement = elementUtils.getTypeElement(it.name());
                if ((theTypeElement == null || !AptTypeInfoFactory.isTypeInThisModule(ctx, theTypeElement, moduleName)) && AptTypeInfoFactory.hasValue((String)moduleName.get())) {
                    builder.putReferencedModuleName(it, (String)moduleName.get());
                }
            });
            ModuleElement module = ctx.aptEnv().getElementUtils().getModuleOf(typeElement);
            if (module != null) {
                builder.module(module.toString());
            }
            builder.referencedTypeNamesToAnnotations(AptTypeInfoFactory.toMetaAnnotations(ctx, annotationsOnTypeOrElements));
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to process: " + String.valueOf(typeElement), e);
        }
    }

    private static TypeName declaredTypeName(AptContext ctx, TypeName typeName) {
        TypeElement typeElement = ctx.aptEnv().getElementUtils().getTypeElement(typeName.fqName());
        return AptTypeFactory.createTypeName(typeElement.asType()).orElseThrow();
    }

    private static void collectEnclosedElements(Predicate<TypedElementInfo> elementPredicate, List<TypedElementInfo> elementsWeCareAbout, List<TypedElementInfo> otherElements, Set<TypeName> annotationsOnTypeOrElements, TypedElementInfo enclosedElement) {
        if (elementPredicate.test(enclosedElement)) {
            elementsWeCareAbout.add(enclosedElement);
        } else {
            otherElements.add(enclosedElement);
        }
        annotationsOnTypeOrElements.addAll(enclosedElement.annotations().stream().map(rec$ -> ((Annotation)rec$).typeName()).collect(Collectors.toSet()));
        enclosedElement.parameterArguments().forEach(arg -> annotationsOnTypeOrElements.addAll(arg.annotations().stream().map(rec$ -> ((Annotation)rec$).typeName()).collect(Collectors.toSet())));
    }

    private static AccessModifier accessModifier(Set<String> stringModifiers) {
        for (String stringModifier : stringModifiers) {
            try {
                return AccessModifier.valueOf((String)stringModifier.toUpperCase(Locale.ROOT));
            }
            catch (Exception exception) {
            }
        }
        return AccessModifier.PACKAGE_PRIVATE;
    }

    private static List<Annotation> createAnnotations(AptContext ctx, Element element, Elements elements) {
        io.helidon.common.types.ElementKind elementKind = AptTypeInfoFactory.kind(element.getKind());
        return element.getAnnotationMirrors().stream().map(it -> AptAnnotationFactory.createAnnotation(it, elements)).flatMap(it -> AptTypeInfoFactory.mapAnnotation((CodegenContext)ctx, (Annotation)it, (io.helidon.common.types.ElementKind)elementKind).stream()).filter(x$0 -> TypeInfoFactoryBase.annotationFilter((Annotation)x$0)).toList();
    }

    private static List<Annotation> createInheritedAnnotations(AptContext ctx, TypeName processedType, List<Annotation> elementAnnotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        HashSet<TypeName> processedTypes = new HashSet<TypeName>();
        for (Annotation elementAnnotation : elementAnnotations) {
            if (processedType.equals((Object)elementAnnotation.typeName())) continue;
            AptTypeInfoFactory.addInherited(ctx, result, processedTypes, elementAnnotation, false);
        }
        return result;
    }

    private static void addInherited(AptContext ctx, List<Annotation> result, Set<TypeName> processedTypes, Annotation annotation, boolean shouldAdd) {
        TypeName annotationType = annotation.typeName();
        if (!processedTypes.add(annotationType)) {
            return;
        }
        if (!AptTypeInfoFactory.annotationFilter((Annotation)annotation)) {
            return;
        }
        if (annotationType.equals((Object)TypeNames.INHERITED)) {
            return;
        }
        Optional<TypeInfo> found = AptTypeInfoFactory.create(ctx, annotationType, (TypedElementInfo it) -> false);
        if (found.isEmpty()) {
            ctx.logger().log(System.Logger.Level.DEBUG, "Annotation " + String.valueOf(annotationType) + " not available, cannot obtain inherited annotations");
            return;
        }
        TypeInfo annoTypeInfo = found.get();
        if (annoTypeInfo.hasAnnotation(TypeNames.INHERITED)) {
            if (shouldAdd) {
                result.add(annotation);
            }
            for (Annotation metaAnnotation : annoTypeInfo.annotations()) {
                if (annotationType.equals((Object)metaAnnotation.typeName())) continue;
                AptTypeInfoFactory.addInherited(ctx, result, processedTypes, metaAnnotation, true);
            }
        }
    }

    private static Set<String> toModifierNames(Set<Modifier> modifiers) {
        return modifiers.stream().map(Enum::name).collect(Collectors.toSet());
    }

    private static boolean isTypeInThisModule(AptContext ctx, TypeElement type, AtomicReference<String> moduleName) {
        String name;
        moduleName.set(null);
        ModuleElement module = ctx.aptEnv().getElementUtils().getModuleOf(type);
        if (module != null && !module.isUnnamed() && AptTypeInfoFactory.hasValue(name = module.getQualifiedName().toString())) {
            moduleName.set(name);
        }
        try {
            Trees trees = Trees.instance(ctx.aptEnv());
            TreePath path = trees.getPath(type);
            if (path == null) {
                return false;
            }
            JavaFileObject sourceFile = path.getCompilationUnit().getSourceFile();
            return sourceFile != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Map<TypeName, List<Annotation>> toMetaAnnotations(AptContext ctx, Set<TypeName> annotations) {
        if (annotations.isEmpty()) {
            return Map.of();
        }
        HashMap<TypeName, List<Annotation>> result = new HashMap<TypeName, List<Annotation>>();
        AptTypeInfoFactory.gatherMetaAnnotations(ctx, annotations, result);
        return result;
    }

    private static void gatherMetaAnnotations(AptContext ctx, Set<TypeName> annotationTypes, Map<TypeName, List<Annotation>> result) {
        if (annotationTypes.isEmpty()) {
            return;
        }
        Elements elements = ctx.aptEnv().getElementUtils();
        annotationTypes.stream().filter(Predicate.not(result::containsKey)).forEach(it -> {
            List<Object> meta = META_ANNOTATION_CACHE.get(it);
            boolean fromCache = true;
            if (meta == null) {
                fromCache = false;
                TypeElement typeElement = elements.getTypeElement(it.fqName());
                if (typeElement != null) {
                    List<Annotation> metaAnnotations = AptTypeInfoFactory.createAnnotations(ctx, typeElement, elements);
                    result.put((TypeName)it, (List<Annotation>)new ArrayList<Annotation>(metaAnnotations));
                    AptTypeInfoFactory.gatherMetaAnnotations(ctx, metaAnnotations.stream().map(rec$ -> ((Annotation)rec$).typeName()).collect(Collectors.toSet()), result);
                    meta = metaAnnotations;
                } else {
                    meta = List.of();
                }
            }
            if (!fromCache) {
                META_ANNOTATION_CACHE.putIfAbsent((TypeName)it, (List<Annotation>)meta);
            }
            if (!meta.isEmpty()) {
                result.put((TypeName)it, (List<Annotation>)meta);
            }
        });
    }

    private static boolean hasValue(String val) {
        return val != null && !val.isBlank();
    }
}

