/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.FilerResource;
import io.helidon.codegen.FilerTextResource;
import io.helidon.codegen.IndentType;
import io.helidon.codegen.apt.FilerResourceImpl;
import io.helidon.codegen.apt.FilerTextResourceImpl;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.TypeName;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class AptFiler
implements CodegenFiler {
    private final Filer filer;
    private final String indent;

    AptFiler(ProcessingEnvironment env, CodegenOptions options) {
        this.filer = env.getFiler();
        IndentType value = (IndentType)CodegenOptions.INDENT_TYPE.value(options);
        int codegenRepeat = (Integer)CodegenOptions.INDENT_COUNT.value(options);
        this.indent = String.valueOf(value.character()).repeat(codegenRepeat);
    }

    public Path writeSourceFile(ClassModel classModel, Object ... originatingElements) {
        Element[] elements = this.toElements(originatingElements);
        try {
            JavaFileObject sourceFile = this.filer.createSourceFile(classModel.typeName().fqName(), elements);
            try (Writer os = sourceFile.openWriter();){
                classModel.write(os, this.indent);
            }
            return Path.of(sourceFile.toUri());
        }
        catch (IOException e) {
            throw new CodegenException("Failed to write source file for type: " + String.valueOf(classModel.typeName()), (Throwable)e, this.originatingElement(elements, classModel.typeName()));
        }
    }

    public Path writeSourceFile(TypeName type, String content, Object ... originatingElements) {
        Element[] elements = this.toElements(originatingElements);
        try {
            JavaFileObject sourceFile = this.filer.createSourceFile(type.fqName(), elements);
            try (Writer os = sourceFile.openWriter();){
                os.write(content);
            }
            return Path.of(sourceFile.toUri());
        }
        catch (IOException e) {
            throw new CodegenException("Failed to write source file for type: " + String.valueOf(type), (Throwable)e, this.originatingElement(elements, type));
        }
    }

    public Path writeResource(byte[] resource, String location, Object ... originatingElements) {
        Element[] elements = this.toElements(originatingElements);
        try {
            FileObject fileObject = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", location, elements);
            try (OutputStream os = fileObject.openOutputStream();){
                os.write(resource);
            }
            return Path.of(fileObject.toUri());
        }
        catch (IOException e) {
            throw new CodegenException("Failed to write resource file " + location, (Throwable)e, this.originatingElement(elements, location));
        }
    }

    public FilerTextResource textResource(String location, Object ... originatingElements) {
        try {
            FileObject resource = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", location);
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resource.openInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            return new FilerTextResourceImpl(this.filer, location, this.toElements(originatingElements), resource, lines);
        }
        catch (IOException e) {
            return new FilerTextResourceImpl(this.filer, location, this.toElements(originatingElements));
        }
    }

    public FilerResource resource(String location, Object ... originatingElements) {
        try {
            FileObject resource = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", location);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream is = resource.openInputStream();){
                is.transferTo(baos);
            }
            return new FilerResourceImpl(this.filer, location, this.toElements(originatingElements), resource, baos.toByteArray());
        }
        catch (IOException e) {
            return new FilerResourceImpl(this.filer, location, this.toElements(originatingElements));
        }
    }

    private Object originatingElement(Element[] elements, Object alternative) {
        if (elements.length == 0) {
            return alternative;
        }
        return elements[0];
    }

    private Element[] toElements(Object[] originatingElements) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Object originatingElement : originatingElements) {
            if (!(originatingElement instanceof Element)) continue;
            Element element = (Element)originatingElement;
            result.add(element);
        }
        return result.toArray(new Element[0]);
    }
}

