/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.AnnotationDataOption;
import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.MethodSignature;
import io.helidon.builder.processor.ProcessingContext;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.processor.classmodel.Field;
import io.helidon.common.processor.classmodel.InnerClass;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.Optional;
import java.util.Set;

record PrototypeProperty(MethodSignature signature, TypeHandler typeHandler, AnnotationDataOption configuredOption, FactoryMethods factoryMethods, boolean equality, boolean toStringValue, boolean confidential) {
    private static final Set<String> RESERVED_WORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null");

    static PrototypeProperty create(ProcessingContext processingContext, TypeInfo blueprint, TypedElementInfo element, boolean beanStyleAccessors) {
        boolean isBoolean = element.typeName().boxed().equals((Object)Types.BOXED_BOOLEAN_TYPE);
        String getterName = element.elementName();
        Object name = PrototypeProperty.propertyName(getterName, isBoolean, beanStyleAccessors);
        String setterName = PrototypeProperty.setterName((String)name, beanStyleAccessors);
        if (RESERVED_WORDS.contains(name)) {
            name = "the" + GeneratorTools.capitalize((String)name);
        }
        TypeName returnType = PrototypeProperty.propertyTypeName(element);
        boolean sameGeneric = element.hasAnnotation(Types.OPTION_SAME_GENERIC_TYPE);
        TypeHandler typeHandler = TypeHandler.create((String)name, getterName, setterName, returnType, sameGeneric);
        AnnotationDataOption configuredOption = AnnotationDataOption.create(typeHandler, element);
        FactoryMethods factoryMethods = FactoryMethods.create(processingContext, blueprint, typeHandler);
        boolean confidential = element.hasAnnotation(Types.OPTION_CONFIDENTIAL_TYPE);
        Optional redundantAnnotation = element.findAnnotation(Types.OPTION_REDUNDANT_TYPE);
        boolean toStringValue = redundantAnnotation.flatMap(it -> it.getValue("stringValue")).map(Boolean::parseBoolean).orElse(false) == false;
        boolean equality = redundantAnnotation.flatMap(it -> it.getValue("equality")).map(Boolean::parseBoolean).orElse(false) == false;
        return new PrototypeProperty(MethodSignature.create(element), typeHandler, configuredOption, factoryMethods, equality, toStringValue, confidential);
    }

    private static TypeName propertyTypeName(TypedElementInfo element) {
        return element.findAnnotation(Types.OPTION_TYPE).flatMap(Annotation::value).map(TypeName::create).orElseGet(() -> ((TypedElementInfo)element).typeName());
    }

    Field.Builder fieldDeclaration(boolean isBuilder) {
        return this.typeHandler.fieldDeclaration(this.configuredOption(), isBuilder, !isBuilder);
    }

    void setters(InnerClass.Builder classBuilder, TypeName builderType, Javadoc blueprintJavadoc) {
        this.typeHandler().setters(classBuilder, this.configuredOption(), this.factoryMethods(), builderType, blueprintJavadoc);
    }

    String name() {
        return this.typeHandler.name();
    }

    String getterName() {
        return this.typeHandler.getterName();
    }

    String setterName() {
        return this.typeHandler.setterName();
    }

    TypeName typeName() {
        return this.typeHandler.declaredType();
    }

    TypeName builderGetterType() {
        return this.typeHandler.builderGetterType(this.configuredOption.required(), this.configuredOption.hasDefault());
    }

    String builderGetter() {
        return this.typeHandler.generateBuilderGetter(this.configuredOption.required(), this.configuredOption.hasDefault());
    }

    boolean builderGetterOptional() {
        return this.typeHandler.builderGetterOptional(this.configuredOption.required(), this.configuredOption.hasDefault());
    }

    private static String setterName(String name, boolean beanStyleAccessors) {
        if (beanStyleAccessors || RESERVED_WORDS.contains(name)) {
            return "set" + GeneratorTools.capitalize((String)name);
        }
        return name;
    }

    private static String propertyName(String getterName, boolean isBoolean, boolean beanStyleAccessors) {
        if (beanStyleAccessors) {
            if (isBoolean && getterName.startsWith("is")) {
                return PrototypeProperty.deCapitalize(getterName.substring(2));
            }
            if (getterName.startsWith("get")) {
                return PrototypeProperty.deCapitalize(getterName.substring(3));
            }
        }
        return getterName;
    }

    private static String deCapitalize(String string) {
        if (string.isBlank()) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }
}

