/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.ProcessingContext;
import io.helidon.builder.processor.TypeContext;
import io.helidon.builder.processor.Types;
import io.helidon.common.Errors;
import io.helidon.common.processor.ElementInfoPredicates;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

record CustomMethods(List<CustomMethod> factoryMethods, List<CustomMethod> builderMethods, List<CustomMethod> prototypeMethods) {
    CustomMethods() {
        this(List.of(), List.of(), List.of());
    }

    static CustomMethods create(ProcessingContext ctx, TypeContext.TypeInformation typeInformation) {
        Optional annotation = typeInformation.blueprintType().findAnnotation(Types.CUSTOM_METHODS_TYPE);
        if (annotation.isEmpty()) {
            return new CustomMethods();
        }
        String customMethodType = (String)((Annotation)annotation.get()).value().orElseThrow();
        TypeInfo customMethodsInfo = ctx.toTypeInfo(TypeName.create((String)customMethodType)).orElseThrow();
        Errors.Collector errors = Errors.collector();
        List<CustomMethod> factoryMethods = CustomMethods.findMethods(typeInformation, customMethodsInfo, errors, Types.FACTORY_METHOD_TYPE, CustomMethods::factoryMethod);
        List<CustomMethod> builderMethods = CustomMethods.findMethods(typeInformation, customMethodsInfo, errors, Types.BUILDER_CUSTOM_METHOD_TYPE, CustomMethods::builderMethod);
        List<CustomMethod> prototypeMethods = CustomMethods.findMethods(typeInformation, customMethodsInfo, errors, Types.PROTOTYPE_CUSTOM_METHOD_TYPE, CustomMethods::prototypeMethod);
        errors.collect().checkValid();
        return new CustomMethods(factoryMethods, builderMethods, prototypeMethods);
    }

    private static GeneratedMethod prototypeMethod(Errors.Collector errors, TypeContext.TypeInformation typeInformation, TypeName customMethodsType, List<String> annotations, Method customMethod) {
        List<Argument> customMethodArgs = customMethod.arguments();
        if (customMethodArgs.isEmpty()) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.PrototypeMethod must accept the prototype as the first parameter, but method: " + customMethod.name() + " has no parameters");
        } else if (!CustomMethods.correctType(typeInformation.prototype(), customMethodArgs.get(0).typeName())) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.PrototypeMethod must accept the prototype as the first parameter, but method: " + customMethod.name() + " expected: " + typeInformation.prototypeBuilder().fqName() + " actual: " + customMethodArgs.get(0).typeName().fqName());
        }
        List<Argument> generatedArgs = customMethodArgs.subList(1, customMethodArgs.size());
        ArrayList<String> argumentNames = new ArrayList<String>();
        argumentNames.add("this");
        argumentNames.addAll(generatedArgs.stream().map(Argument::name).toList());
        String generatedCall = Types.VOID_TYPE.equals((Object)customMethod.returnType) ? "" : "return @" + customMethodsType.genericTypeName().fqName() + "@." + customMethod.name() + "(" + String.join((CharSequence)", ", argumentNames) + ")";
        return new GeneratedMethod(new Method(typeInformation.prototypeBuilder(), customMethod.name(), customMethod.returnType(), generatedArgs, customMethod.javadoc()), annotations, generatedCall);
    }

    private static GeneratedMethod builderMethod(Errors.Collector errors, TypeContext.TypeInformation typeInformation, TypeName customMethodsType, List<String> annotations, Method customMethod) {
        List<Argument> customMethodArgs = customMethod.arguments();
        if (customMethodArgs.isEmpty()) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.BuilderMethod must accept the prototype builder base as the first parameter, but method: " + customMethod.name() + " has no parameters");
        } else if (!CustomMethods.correctType(typeInformation.prototypeBuilderBase(), customMethodArgs.get(0).typeName().genericTypeName())) {
            errors.fatal((Object)customMethodsType.fqName(), "Methods annotated with @Prototype.BuilderMethod must accept the prototype builder base as the first parameter, but method: " + customMethod.name() + " expected: " + typeInformation.prototypeBuilderBase().fqName() + " actual: " + customMethodArgs.get(0).typeName().fqName());
        }
        List<Argument> generatedArgs = customMethodArgs.subList(1, customMethodArgs.size());
        ArrayList<String> argumentNames = new ArrayList<String>();
        argumentNames.add("this");
        argumentNames.addAll(generatedArgs.stream().map(Argument::name).toList());
        String generatedCall = "@" + customMethodsType.genericTypeName().fqName() + "@." + customMethod.name() + "(" + String.join((CharSequence)", ", argumentNames) + ");\nreturn self()";
        return new GeneratedMethod(new Method(typeInformation.prototypeBuilder(), customMethod.name(), typeInformation.prototypeBuilder(), generatedArgs, customMethod.javadoc()), annotations, generatedCall);
    }

    private static boolean correctType(TypeName knownType, TypeName processingType) {
        if (processingType.packageName().isEmpty()) {
            if (processingType.className().equals("<any>")) {
                return true;
            }
            return knownType.className().equals(processingType.className()) && knownType.enclosingNames().equals(processingType.enclosingNames());
        }
        return knownType.equals((Object)processingType);
    }

    private static GeneratedMethod factoryMethod(Errors.Collector errors, TypeContext.TypeInformation typeInformation, TypeName customMethodsType, List<String> annotations, Method customMethod) {
        String generatedCall = Types.VOID_TYPE.equals((Object)customMethod.returnType) ? "" : "return @" + customMethodsType.genericTypeName().fqName() + "@." + customMethod.name() + "(" + customMethod.arguments().stream().map(Argument::name).collect(Collectors.joining(", ")) + ")";
        return new GeneratedMethod(new Method(typeInformation.prototype(), customMethod.name(), customMethod.returnType(), customMethod.arguments(), customMethod.javadoc()), annotations, generatedCall);
    }

    private static List<CustomMethod> findMethods(TypeContext.TypeInformation typeInformation, TypeInfo customMethodsType, Errors.Collector errors, TypeName requiredAnnotation, MethodProcessor methodProcessor) {
        return customMethodsType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.hasAnnotation((TypeName)requiredAnnotation)).map(it -> {
            TypeName returnType = it.typeName();
            String methodName = it.elementName();
            List<Argument> arguments = it.parameterArguments().stream().map(arg -> new Argument(arg.elementName(), arg.typeName())).toList();
            List javadoc = it.description().map(String::trim).stream().filter(Predicate.not(String::isBlank)).findAny().map(description -> description.split("\n")).map(List::of).orElseGet(List::of);
            List<String> annotations = it.findAnnotation(Types.PROTOTYPE_ANNOTATED_TYPE).flatMap(Annotation::stringValues).orElseGet(List::of).stream().map(String::trim).filter(Predicate.not(String::isBlank)).toList();
            Method customMethod = new Method(customMethodsType.typeName(), methodName, returnType, arguments, javadoc);
            return new CustomMethod(customMethod, methodProcessor.process(errors, typeInformation, customMethodsType.typeName(), annotations, customMethod));
        }).toList();
    }

    static interface MethodProcessor {
        public GeneratedMethod process(Errors.Collector var1, TypeContext.TypeInformation var2, TypeName var3, List<String> var4, Method var5);
    }

    record Method(TypeName declaringType, String name, TypeName returnType, List<Argument> arguments, List<String> javadoc) {
    }

    record Argument(String name, TypeName typeName) {
    }

    record GeneratedMethod(Method method, List<String> annotations, String callCode) {
    }

    record CustomMethod(Method declaredMethod, GeneratedMethod generatedMethod) {
    }
}

