/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.AnnotationDataOption;
import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.classmodel.Field;
import io.helidon.common.processor.classmodel.InnerClass;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.processor.classmodel.Method;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.Objects;
import java.util.function.Consumer;

class TypeHandlerSupplier
extends TypeHandler.OneTypeHandler {
    TypeHandlerSupplier(String name, String getterName, String setterName, TypeName declaredType) {
        super(name, getterName, setterName, declaredType);
    }

    @Override
    Field.Builder fieldDeclaration(AnnotationDataOption configured, boolean isBuilder, boolean alwaysFinal) {
        Field.Builder builder = ((Field.Builder)Field.builder().type(this.declaredType()).name(this.name())).isFinal(alwaysFinal || !isBuilder);
        if (isBuilder && configured.hasDefault()) {
            builder.defaultValue("() -> " + configured.defaultValue());
        }
        return builder;
    }

    @Override
    TypeName argumentTypeName() {
        return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(TypeHandlerSupplier.toWildcard(this.actualType()))).build();
    }

    @Override
    void generateFromConfig(Method.Builder method, AnnotationDataOption configured, FactoryMethods factoryMethods) {
        if (configured.provider()) {
            return;
        }
        if (factoryMethods.createFromConfig().isPresent()) {
            method.addLine(this.configGet(configured) + this.generateFromConfig(factoryMethods) + ".ifPresent(this::" + this.setterName() + ");");
        } else if (this.actualType().isOptional()) {
            method.add(this.setterName() + "(");
            method.add(this.configGet(configured));
            method.add(this.generateFromConfigOptional(factoryMethods));
            method.addLine(".optionalSupplier());");
        } else {
            method.add(this.setterName() + "(");
            method.add(this.configGet(configured));
            method.add(this.generateFromConfig(factoryMethods));
            method.addLine(".supplier());");
        }
    }

    String generateFromConfigOptional(FactoryMethods factoryMethods) {
        TypeName optionalType = (TypeName)this.actualType().typeArguments().get(0);
        if (optionalType.fqName().equals("char[]")) {
            return ".asString().as(String::toCharArray)";
        }
        TypeName boxed = optionalType.boxed();
        return factoryMethods.createFromConfig().map(it -> ".map(" + it.typeWithFactoryMethod().genericTypeName().fqName() + "::" + it.createMethodName() + ")").orElseGet(() -> ".as(" + boxed.fqName() + ".class)");
    }

    @Override
    void setters(InnerClass.Builder classBuilder, AnnotationDataOption configured, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        FactoryMethods.FactoryMethod fm;
        this.declaredSetter(classBuilder, configured, returnType, blueprintJavadoc);
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).description(blueprintJavadoc.content())).returnType(returnType, "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.actualType()).description(blueprintJavadoc.returnDescription()))).addJavadocTag("see", "#" + this.getterName() + "()")).typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + " = () -> " + this.name() + ";")).addLine("return self();");
        classBuilder.addMethod(method);
        if (this.actualType().equals((Object)Types.CHAR_ARRAY_TYPE)) {
            classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(Types.STRING_TYPE).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + " = () -> " + this.name() + ".toCharArray();")).addLine("return self();"));
        }
        if (factoryMethod.createTargetType().isPresent()) {
            fm = factoryMethod.createTargetType().get();
            String argumentName = this.name() + "Config";
            classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).description(blueprintJavadoc.content())).returnType(returnType, "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(fm.argumentType()).description(blueprintJavadoc.returnDescription()))).addJavadocTag("see", "#" + this.getterName() + "()")).typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).add("this." + this.name() + " = ")).typeName(fm.typeWithFactoryMethod().genericTypeName())).addLine("." + fm.createMethodName() + "(" + argumentName + ");")).addLine("return self();"));
        }
        if (factoryMethod.builder().isPresent()) {
            fm = factoryMethod.builder().get();
            String className = fm.factoryMethodReturnType().className();
            TypeName builderType = className.equals("Builder") || className.endsWith(".Builder") ? fm.factoryMethodReturnType() : TypeName.create((String)(fm.factoryMethodReturnType().fqName() + ".Builder"));
            String argumentName = "consumer";
            TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
            Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, blueprintJavadoc.returnDescription()).build();
            classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).returnType(returnType).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).javadoc(javadoc)).typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).add("var builder = ")).typeName(fm.typeWithFactoryMethod().genericTypeName())).addLine("." + fm.createMethodName() + "();")).addLine("consumer.accept(builder);")).addLine("this." + this.name() + "(builder.build());")).addLine("return self();"));
        }
    }

    @Override
    protected void declaredSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerSupplier.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + " = " + this.name() + "::get;")).addLine("return self();"));
    }
}

